package networkwatcher

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// Access enumerates the values for access.
type Access string

const (
	// Allow specifies the allow state for access.
	Allow Access = "Allow"
	// Deny specifies the deny state for access.
	Deny Access = "Deny"
)

// AssociationType enumerates the values for association type.
type AssociationType string

const (
	// Associated specifies the associated state for association type.
	Associated AssociationType = "Associated"
	// Contains specifies the contains state for association type.
	Contains AssociationType = "Contains"
)

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound specifies the inbound state for direction.
	Inbound Direction = "Inbound"
	// Outbound specifies the outbound state for direction.
	Outbound Direction = "Outbound"
)

// NextHopType enumerates the values for next hop type.
type NextHopType string

const (
	// HyperNetGateway specifies the hyper net gateway state for next hop type.
	HyperNetGateway NextHopType = "HyperNetGateway"
	// Internet specifies the internet state for next hop type.
	Internet NextHopType = "Internet"
	// None specifies the none state for next hop type.
	None NextHopType = "None"
	// VirtualAppliance specifies the virtual appliance state for next hop
	// type.
	VirtualAppliance NextHopType = "VirtualAppliance"
	// VirtualNetworkGateway specifies the virtual network gateway state for
	// next hop type.
	VirtualNetworkGateway NextHopType = "VirtualNetworkGateway"
	// VnetLocal specifies the vnet local state for next hop type.
	VnetLocal NextHopType = "VnetLocal"
)

// PcError enumerates the values for pc error.
type PcError string

const (
	// AgentStopped specifies the agent stopped state for pc error.
	AgentStopped PcError = "AgentStopped"
	// CaptureFailed specifies the capture failed state for pc error.
	CaptureFailed PcError = "CaptureFailed"
	// InternalError specifies the internal error state for pc error.
	InternalError PcError = "InternalError"
	// LocalFileFailed specifies the local file failed state for pc error.
	LocalFileFailed PcError = "LocalFileFailed"
	// StorageFailed specifies the storage failed state for pc error.
	StorageFailed PcError = "StorageFailed"
)

// PcProtocol enumerates the values for pc protocol.
type PcProtocol string

const (
	// Any specifies the any state for pc protocol.
	Any PcProtocol = "Any"
	// TCP specifies the tcp state for pc protocol.
	TCP PcProtocol = "TCP"
	// UDP specifies the udp state for pc protocol.
	UDP PcProtocol = "UDP"
)

// PcStatus enumerates the values for pc status.
type PcStatus string

const (
	// Error specifies the error state for pc status.
	Error PcStatus = "Error"
	// NotStarted specifies the not started state for pc status.
	NotStarted PcStatus = "NotStarted"
	// Running specifies the running state for pc status.
	Running PcStatus = "Running"
	// Stopped specifies the stopped state for pc status.
	Stopped PcStatus = "Stopped"
	// Unknown specifies the unknown state for pc status.
	Unknown PcStatus = "Unknown"
)

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolTCP specifies the protocol tcp state for protocol.
	ProtocolTCP Protocol = "TCP"
	// ProtocolUDP specifies the protocol udp state for protocol.
	ProtocolUDP Protocol = "UDP"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Deleting specifies the deleting state for provisioning state.
	Deleting ProvisioningState = "Deleting"
	// Failed specifies the failed state for provisioning state.
	Failed ProvisioningState = "Failed"
	// Succeeded specifies the succeeded state for provisioning state.
	Succeeded ProvisioningState = "Succeeded"
	// Updating specifies the updating state for provisioning state.
	Updating ProvisioningState = "Updating"
)

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// SecurityRuleAccessAllow specifies the security rule access allow state
	// for security rule access.
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	// SecurityRuleAccessDeny specifies the security rule access deny state for
	// security rule access.
	SecurityRuleAccessDeny SecurityRuleAccess = "Deny"
)

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// SecurityRuleDirectionInbound specifies the security rule direction
	// inbound state for security rule direction.
	SecurityRuleDirectionInbound SecurityRuleDirection = "Inbound"
	// SecurityRuleDirectionOutbound specifies the security rule direction
	// outbound state for security rule direction.
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAsterisk specifies the security rule protocol
	// asterisk state for security rule protocol.
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolTCP specifies the security rule protocol tcp state
	// for security rule protocol.
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP specifies the security rule protocol udp state
	// for security rule protocol.
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// EffectiveNetworkSecurityRule is effective network security rules.
type EffectiveNetworkSecurityRule struct {
	Name                             *string               `json:"name,omitempty"`
	Protocol                         SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange                  *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange             *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix              *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix         *string               `json:"destinationAddressPrefix,omitempty"`
	ExpandedSourceAddressPrefix      *[]string             `json:"expandedSourceAddressPrefix,omitempty"`
	ExpandedDestinationAddressPrefix *[]string             `json:"expandedDestinationAddressPrefix,omitempty"`
	Access                           SecurityRuleAccess    `json:"access,omitempty"`
	Priority                         *int32                `json:"priority,omitempty"`
	Direction                        SecurityRuleDirection `json:"direction,omitempty"`
}

// FlowLogInformation is information on the configuration of flow log.
type FlowLogInformation struct {
	autorest.Response  `json:"-"`
	TargetResourceID   *string `json:"targetResourceId,omitempty"`
	*FlowLogProperties `json:"properties,omitempty"`
}

// FlowLogProperties is parameters that define the configuration of flow log.
type FlowLogProperties struct {
	StorageID       *string                    `json:"storageId,omitempty"`
	Enabled         *bool                      `json:"enabled,omitempty"`
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
}

// FlowLogStatusParameters is parameters that define a resource to query flow
// log status.
type FlowLogStatusParameters struct {
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// ListResult is list of network watcher resources.
type ListResult struct {
	autorest.Response `json:"-"`
	Value             *[]NetworkWatcher `json:"value,omitempty"`
}

// NetworkInterfaceAssociation is network interface and its custom security
// rules.
type NetworkInterfaceAssociation struct {
	ID            *string         `json:"id,omitempty"`
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// NetworkWatcher is network watcher in a resource group.
type NetworkWatcher struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Etag              *string             `json:"etag,omitempty"`
	*PropertiesFormat `json:"properties,omitempty"`
}

// NextHopParameters is parameters that define the source and destination
// endpoint.
type NextHopParameters struct {
	TargetResourceID     *string `json:"targetResourceId,omitempty"`
	SourceIPAddress      *string `json:"sourceIPAddress,omitempty"`
	DestinationIPAddress *string `json:"destinationIPAddress,omitempty"`
	TargetNicResourceID  *string `json:"targetNicResourceId,omitempty"`
}

// NextHopResult is the information about next hop from the specified VM.
type NextHopResult struct {
	autorest.Response `json:"-"`
	NextHopType       NextHopType `json:"nextHopType,omitempty"`
	NextHopIPAddress  *string     `json:"nextHopIpAddress,omitempty"`
	RouteTableID      *string     `json:"routeTableId,omitempty"`
}

// PacketCapture is parameters that define the create packet capture operation.
type PacketCapture struct {
	*PacketCaptureParameters `json:"properties,omitempty"`
}

// PacketCaptureFilter is filter that is applied to packet capture request.
// Multiple filters can be applied.
type PacketCaptureFilter struct {
	Protocol        PcProtocol `json:"protocol,omitempty"`
	LocalIPAddress  *string    `json:"localIPAddress,omitempty"`
	RemoteIPAddress *string    `json:"remoteIPAddress,omitempty"`
	LocalPort       *string    `json:"localPort,omitempty"`
	RemotePort      *string    `json:"remotePort,omitempty"`
}

// PacketCaptureListResult is list of packet capture sessions.
type PacketCaptureListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PacketCaptureResult `json:"value,omitempty"`
}

// PacketCaptureParameters is parameters that define the create packet capture
// operation.
type PacketCaptureParameters struct {
	Target                  *string                       `json:"target,omitempty"`
	BytesToCapturePerPacket *int32                        `json:"bytesToCapturePerPacket,omitempty"`
	TotalBytesPerSession    *int32                        `json:"totalBytesPerSession,omitempty"`
	TimeLimitInSeconds      *int32                        `json:"timeLimitInSeconds,omitempty"`
	StorageLocation         *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	Filters                 *[]PacketCaptureFilter        `json:"filters,omitempty"`
}

// PacketCaptureQueryStatusResult is status of packet capture session.
type PacketCaptureQueryStatusResult struct {
	autorest.Response   `json:"-"`
	Name                *string    `json:"name,omitempty"`
	ID                  *string    `json:"id,omitempty"`
	CaptureStartTime    *date.Time `json:"captureStartTime,omitempty"`
	PacketCaptureStatus PcStatus   `json:"packetCaptureStatus,omitempty"`
	StopReason          *string    `json:"stopReason,omitempty"`
	PacketCaptureError  *[]PcError `json:"packetCaptureError,omitempty"`
}

// PacketCaptureResult is information about packet capture session.
type PacketCaptureResult struct {
	autorest.Response              `json:"-"`
	Name                           *string `json:"name,omitempty"`
	ID                             *string `json:"id,omitempty"`
	Etag                           *string `json:"etag,omitempty"`
	*PacketCaptureResultProperties `json:"properties,omitempty"`
}

// PacketCaptureResultProperties is describes the properties of a packet
// capture session.
type PacketCaptureResultProperties struct {
	Target                  *string                       `json:"target,omitempty"`
	BytesToCapturePerPacket *int32                        `json:"bytesToCapturePerPacket,omitempty"`
	TotalBytesPerSession    *int32                        `json:"totalBytesPerSession,omitempty"`
	TimeLimitInSeconds      *int32                        `json:"timeLimitInSeconds,omitempty"`
	StorageLocation         *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	Filters                 *[]PacketCaptureFilter        `json:"filters,omitempty"`
	ProvisioningState       ProvisioningState             `json:"provisioningState,omitempty"`
}

// PacketCaptureStorageLocation is describes the storage location for a packet
// capture session.
type PacketCaptureStorageLocation struct {
	StorageID   *string `json:"storageId,omitempty"`
	StoragePath *string `json:"storagePath,omitempty"`
	FilePath    *string `json:"filePath,omitempty"`
}

// PropertiesFormat is the network watcher properties.
type PropertiesFormat struct {
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// QueryTroubleshootingParameters is parameters that define the resource to
// query the troubleshooting result.
type QueryTroubleshootingParameters struct {
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// RetentionPolicyParameters is parameters that define the retention policy for
// flow log.
type RetentionPolicyParameters struct {
	Days    *int32 `json:"days,omitempty"`
	Enabled *bool  `json:"enabled,omitempty"`
}

// SecurityGroupNetworkInterface is network interface and all its associated
// security rules.
type SecurityGroupNetworkInterface struct {
	ID                       *string                   `json:"id,omitempty"`
	SecurityRuleAssociations *SecurityRuleAssociations `json:"securityRuleAssociations,omitempty"`
}

// SecurityGroupViewParameters is parameters that define the VM to check
// security groups for.
type SecurityGroupViewParameters struct {
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// SecurityGroupViewResult is the information about security rules applied to
// the specified VM.
type SecurityGroupViewResult struct {
	autorest.Response `json:"-"`
	NetworkInterfaces *[]SecurityGroupNetworkInterface `json:"networkInterfaces,omitempty"`
}

// SecurityRule is network security rule.
type SecurityRule struct {
	ID                            *string `json:"id,omitempty"`
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Etag                          *string `json:"etag,omitempty"`
}

// SecurityRuleAssociations is all security rules associated with the network
// interface.
type SecurityRuleAssociations struct {
	NetworkInterfaceAssociation *NetworkInterfaceAssociation    `json:"networkInterfaceAssociation,omitempty"`
	SubnetAssociation           *SubnetAssociation              `json:"subnetAssociation,omitempty"`
	DefaultSecurityRules        *[]SecurityRule                 `json:"defaultSecurityRules,omitempty"`
	EffectiveSecurityRules      *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
}

// SecurityRulePropertiesFormat is
type SecurityRulePropertiesFormat struct {
	Description              *string               `json:"description,omitempty"`
	Protocol                 SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange          *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange     *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix      *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix *string               `json:"destinationAddressPrefix,omitempty"`
	Access                   SecurityRuleAccess    `json:"access,omitempty"`
	Priority                 *int32                `json:"priority,omitempty"`
	Direction                SecurityRuleDirection `json:"direction,omitempty"`
	ProvisioningState        *string               `json:"provisioningState,omitempty"`
}

// SubnetAssociation is network interface and its custom security rules.
type SubnetAssociation struct {
	ID            *string         `json:"id,omitempty"`
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// Topology is topology of the specified resource group.
type Topology struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	CreatedDateTime   *date.Time          `json:"createdDateTime,omitempty"`
	LastModified      *date.Time          `json:"lastModified,omitempty"`
	Resources         *[]TopologyResource `json:"resources,omitempty"`
}

// TopologyAssociation is resources that have an association with the parent
// resource.
type TopologyAssociation struct {
	Name            *string         `json:"name,omitempty"`
	ResourceID      *string         `json:"resourceId,omitempty"`
	AssociationType AssociationType `json:"associationType,omitempty"`
}

// TopologyParameters is parameters that define the representation of topology.
type TopologyParameters struct {
	TargetResourceGroupName *string `json:"targetResourceGroupName,omitempty"`
}

// TopologyResource is the network resource topology information for the given
// resource group.
type TopologyResource struct {
	Name         *string                `json:"name,omitempty"`
	ID           *string                `json:"id,omitempty"`
	Location     *string                `json:"location,omitempty"`
	Associations *[]TopologyAssociation `json:"associations,omitempty"`
}

// TroubleshootingDetails is information gained from troubleshooting of
// specified resource.
type TroubleshootingDetails struct {
	ID                 *string                              `json:"id,omitempty"`
	ReasonType         *string                              `json:"reasonType,omitempty"`
	Summary            *string                              `json:"summary,omitempty"`
	Detail             *string                              `json:"detail,omitempty"`
	RecommendedActions *[]TroubleshootingRecommendedActions `json:"recommendedActions,omitempty"`
}

// TroubleshootingParameters is parameters that define the resource to
// troubleshoot.
type TroubleshootingParameters struct {
	TargetResourceID           *string `json:"targetResourceId,omitempty"`
	*TroubleshootingProperties `json:"properties,omitempty"`
}

// TroubleshootingProperties is storage location provided for troubleshoot.
type TroubleshootingProperties struct {
	StorageID   *string `json:"storageId,omitempty"`
	StoragePath *string `json:"storagePath,omitempty"`
}

// TroubleshootingRecommendedActions is recommended actions based on discovered
// issues.
type TroubleshootingRecommendedActions struct {
	ActionID      *string `json:"actionId,omitempty"`
	ActionText    *string `json:"actionText,omitempty"`
	ActionURI     *string `json:"actionUri,omitempty"`
	ActionURIText *string `json:"actionUriText,omitempty"`
}

// TroubleshootingResult is troubleshooting information gained from specified
// resource.
type TroubleshootingResult struct {
	autorest.Response `json:"-"`
	StartTime         *date.Time                `json:"startTime,omitempty"`
	EndTime           *date.Time                `json:"endTime,omitempty"`
	Code              *string                   `json:"code,omitempty"`
	Results           *[]TroubleshootingDetails `json:"results,omitempty"`
}

// VerificationIPFlowParameters is parameters that define the IP flow to be
// verified.
type VerificationIPFlowParameters struct {
	TargetResourceID    *string   `json:"targetResourceId,omitempty"`
	Direction           Direction `json:"direction,omitempty"`
	Protocol            Protocol  `json:"protocol,omitempty"`
	LocalPort           *string   `json:"localPort,omitempty"`
	RemotePort          *string   `json:"remotePort,omitempty"`
	LocalIPAddress      *string   `json:"localIPAddress,omitempty"`
	RemoteIPAddress     *string   `json:"remoteIPAddress,omitempty"`
	TargetNicResourceID *string   `json:"targetNicResourceId,omitempty"`
}

// VerificationIPFlowResult is results of IP flow verification on the target
// resource.
type VerificationIPFlowResult struct {
	autorest.Response `json:"-"`
	Access            Access  `json:"access,omitempty"`
	RuleName          *string `json:"ruleName,omitempty"`
}
