/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui.skins;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;

public class SkinsFactory {
    private static final Log log = LogFactory.getLog(SkinsFactory.class);
    public static final String NO_SKIN = "noskin";
    private String skinName = null;
    private Properties skinProperties = new Properties();
    private static Map unavailableClassMap = new HashMap();

    private SkinsFactory(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        this.skinName = properties.getProperty("skin.name");
        if (this.skinName == null) {
            this.skinName = NO_SKIN;
        }
        String skinPropertyPrefix = "skin." + this.skinName.toLowerCase(Locale.getDefault()) + ".";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            if (!propertyName.toLowerCase(Locale.getDefault()).startsWith(skinPropertyPrefix)) continue;
            String skinPropertyName = propertyName.substring(skinPropertyPrefix.length());
            this.skinProperties.put(skinPropertyName, propertyValue);
        }
    }

    public static SkinsFactory getInstance(Properties properties) {
        return new SkinsFactory(properties);
    }

    public LookAndFeel createSkinnedMetalTheme(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedLookAndFeel"), itemName);
        if (instance != null) {
            return (LookAndFeel)instance;
        }
        return UIManager.getLookAndFeel();
    }

    public JButton createSkinnedJButton(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJButton"), itemName);
        if (instance != null) {
            return (JButton)instance;
        }
        return new JButton();
    }

    public JRadioButton createSkinnedJRadioButton(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJRadioButton"), itemName);
        if (instance != null) {
            return (JRadioButton)instance;
        }
        return new JRadioButton();
    }

    public JComboBox createSkinnedJComboBox(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJComboBox"), itemName);
        if (instance != null) {
            return (JComboBox)instance;
        }
        return new JComboBox();
    }

    public JCheckBox createSkinnedJCheckBox(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJCheckBox"), itemName);
        if (instance != null) {
            return (JCheckBox)instance;
        }
        return new JCheckBox();
    }

    public JPanel createSkinnedJPanel(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJPanel"), itemName);
        if (instance != null) {
            return (JPanel)instance;
        }
        return new JPanel();
    }

    public JTable createSkinnedJTable(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJTable"), itemName);
        if (instance != null) {
            return (JTable)instance;
        }
        return new JTable();
    }

    public JScrollPane createSkinnedJScrollPane(String itemName, Object view) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJScrollPane"), itemName);
        if (instance != null) {
            JScrollPane scrollPane = (JScrollPane)instance;
            scrollPane.setViewportView((Component)view);
            return scrollPane;
        }
        return new JScrollPane((Component)view);
    }

    public JScrollPane createSkinnedJScrollPane(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJScrollPane"), itemName);
        if (instance != null) {
            return (JScrollPane)instance;
        }
        return new JScrollPane();
    }

    public JHtmlLabel createSkinnedJHtmlLabel(String itemName, HyperlinkActivatedListener hyperlinkListener) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJHtmlLabel"), itemName);
        if (instance != null) {
            JHtmlLabel label = (JHtmlLabel)instance;
            label.setHyperlinkeActivatedListener(hyperlinkListener);
            return label;
        }
        return new JHtmlLabel(hyperlinkListener);
    }

    public JHtmlLabel createSkinnedJHtmlLabel(String itemName) {
        return this.createSkinnedJHtmlLabel(itemName, null);
    }

    public JPasswordField createSkinnedJPasswordField(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJPasswordField"), itemName);
        if (instance != null) {
            return (JPasswordField)instance;
        }
        return new JPasswordField();
    }

    public JTextField createSkinnedJTextField(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJTextField"), itemName);
        if (instance != null) {
            return (JTextField)instance;
        }
        return new JTextField();
    }

    public JTextArea createSkinnedJTextArea(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJTextArea"), itemName);
        if (instance != null) {
            return (JTextArea)instance;
        }
        return new JTextArea();
    }

    public JPopupMenu createSkinnedJPopupMenu(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJPopupMenu"), itemName);
        if (instance != null) {
            return (JPopupMenu)instance;
        }
        return new JPopupMenu();
    }

    public JMenuItem createSkinnedJMenuItem(String itemName) {
        Object instance = this.instantiateClass(this.buildSkinnedClassName("SkinnedJMenuItem"), itemName);
        if (instance != null) {
            return (JMenuItem)instance;
        }
        return new JMenuItem();
    }

    public JProgressBar createSkinnedJProgressBar(String itemName, int min, int max) {
        JProgressBar jProgressBar = (JProgressBar)this.instantiateClass(this.buildSkinnedClassName("SkinnedJProgressBar"), itemName);
        if (jProgressBar != null) {
            jProgressBar.setMinimum(min);
            jProgressBar.setMaximum(max);
            return jProgressBar;
        }
        jProgressBar = new JProgressBar(min, max);
        return jProgressBar;
    }

    private String buildSkinnedClassName(String className) {
        if (NO_SKIN.equals(this.skinName)) {
            return null;
        }
        String skinnedClassName = this.getClass().getPackage().getName() + "." + this.skinName + "." + className;
        return skinnedClassName;
    }

    private Object instantiateClass(String className, String itemName) {
        if (className == null) {
            return null;
        }
        if (unavailableClassMap.get(className) != null) {
            return null;
        }
        try {
            Class<?> myClass = Class.forName(className);
            Constructor<?> constructor = myClass.getConstructor(Properties.class, String.class);
            Object instance = constructor.newInstance(this.skinProperties, itemName);
            return instance;
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)("Class does not exist, will use default. Skinned class name: " + className));
        }
        catch (Exception e) {
            log.warn((Object)("Unable to instantiate skinned class '" + className + "'"), (Throwable)e);
        }
        unavailableClassMap.put(className, Boolean.TRUE);
        return null;
    }
}

