/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.amazonaws.services.ec2.model.VolumeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Volume {
    private String volumeId;
    private Integer size;
    private String snapshotId;
    private String availabilityZone;
    private String state;
    private Date createTime;
    private List<VolumeAttachment> attachments;
    private List<Tag> tags;
    private String volumeType;
    private Integer iops;

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public Volume withVolumeId(String volumeId) {
        this.volumeId = volumeId;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Volume withSize(Integer size) {
        this.size = size;
        return this;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Volume withSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Volume withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Volume withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(VolumeState state) {
        this.state = state.toString();
    }

    public Volume withState(VolumeState state) {
        this.state = state.toString();
        return this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Volume withCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public List<VolumeAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<VolumeAttachment>();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<VolumeAttachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        ArrayList<VolumeAttachment> attachmentsCopy = new ArrayList<VolumeAttachment>(attachments.size());
        attachmentsCopy.addAll(attachments);
        this.attachments = attachmentsCopy;
    }

    public Volume withAttachments(VolumeAttachment ... attachments) {
        if (this.getAttachments() == null) {
            this.setAttachments(new ArrayList<VolumeAttachment>(attachments.length));
        }
        for (VolumeAttachment value : attachments) {
            this.getAttachments().add(value);
        }
        return this;
    }

    public Volume withAttachments(Collection<VolumeAttachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
        } else {
            ArrayList<VolumeAttachment> attachmentsCopy = new ArrayList<VolumeAttachment>(attachments.size());
            attachmentsCopy.addAll(attachments);
            this.attachments = attachmentsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Volume withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Volume withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public void setVolumeType(String volumeType) {
        this.volumeType = volumeType;
    }

    public Volume withVolumeType(String volumeType) {
        this.volumeType = volumeType;
        return this;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public Volume withIops(Integer iops) {
        this.iops = iops;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeId != null) {
            sb.append("VolumeId: " + this.volumeId + ", ");
        }
        if (this.size != null) {
            sb.append("Size: " + this.size + ", ");
        }
        if (this.snapshotId != null) {
            sb.append("SnapshotId: " + this.snapshotId + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.state != null) {
            sb.append("State: " + this.state + ", ");
        }
        if (this.createTime != null) {
            sb.append("CreateTime: " + this.createTime + ", ");
        }
        if (this.attachments != null) {
            sb.append("Attachments: " + this.attachments + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        if (this.volumeType != null) {
            sb.append("VolumeType: " + this.volumeType + ", ");
        }
        if (this.iops != null) {
            sb.append("Iops: " + this.iops + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : ((Object)this.getAttachments()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getVolumeType() == null ? 0 : this.getVolumeType().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !((Object)other.getAttachments()).equals(this.getAttachments())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getVolumeType() == null ^ this.getVolumeType() == null) {
            return false;
        }
        if (other.getVolumeType() != null && !other.getVolumeType().equals(this.getVolumeType())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        return other.getIops() == null || other.getIops().equals(this.getIops());
    }
}

