/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.util.regex.Pattern;
import javax.swing.JButton;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JButtonMatcher
extends NamedComponentMatcherTemplate<JButton> {
    private Object text;

    public static JButtonMatcher withName(String name) {
        return new JButtonMatcher(name, ANY);
    }

    public static JButtonMatcher withText(String text) {
        return new JButtonMatcher(ANY, (Object)text);
    }

    public static JButtonMatcher withText(Pattern textPattern) {
        return new JButtonMatcher(ANY, (Object)textPattern);
    }

    public static JButtonMatcher any() {
        return new JButtonMatcher(ANY, ANY);
    }

    private JButtonMatcher(Object name, Object text) {
        super(JButton.class, name);
        this.text = text;
    }

    public JButtonMatcher andText(String newText) {
        this.text = newText;
        return this;
    }

    public JButtonMatcher andText(Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    public JButtonMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(JButton button) {
        if (!this.isNameMatching(button.getName())) {
            return false;
        }
        return this.arePropertyValuesMatching(this.text, button.getText());
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "name=", this.quotedName(), ", ", "text=", this.quoted(this.text), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]"});
    }
}

