/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Html4DocDesc
extends HtmlDocDesc {
    protected static String[] fontMarkup;
    protected static String[] phraseMarkup;
    protected static String[] specialMarkup;
    protected static String[] formMarkup;
    protected static String[] listMarkup;
    protected static List blockContent;
    protected static List flowContent;
    protected static List inlineContent;
    protected static List listContent;
    protected static List bodyContent;
    protected static List coreAttrs;
    protected static List i18nAttrs;
    protected static List eventAttrs;
    protected static List bigAttrs;
    protected static List biggerAttrs;
    protected static List reservedAttrs;
    protected static HtmlAttributeDesc halignAtt;
    protected static HtmlAttributeDesc valignAtt;
    protected static List thtdAtts;

    protected static void classInit4(Map map) {
        phraseMarkup = new String[]{"em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym"};
        formMarkup = new String[]{"input", "select", "textarea", "label", "button"};
        coreAttrs = new ArrayList(4);
        Html4DocDesc.addSimpleAttribute(coreAttrs, "id");
        Html4DocDesc.addSimpleAttribute(coreAttrs, "class");
        Html4DocDesc.addSimpleAttribute(coreAttrs, "style");
        Html4DocDesc.addSimpleAttribute(coreAttrs, "title");
        i18nAttrs = new ArrayList(2);
        Html4DocDesc.addSimpleAttribute(i18nAttrs, "lang");
        i18nAttrs.add(new HtmlAttributeDesc("id", new String[]{"ltr", "rtl"}, 4));
        eventAttrs = new ArrayList(10);
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onclick");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "ondblclick");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmousedown");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmouseup");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmouseover");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmousemove");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmouseout");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onkeypress");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onkeydown");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onkeyup");
        bigAttrs = new ArrayList(coreAttrs.size() + i18nAttrs.size() + eventAttrs.size());
        bigAttrs.addAll(coreAttrs);
        bigAttrs.addAll(i18nAttrs);
        bigAttrs.addAll(eventAttrs);
        reservedAttrs = new ArrayList(3);
        Html4DocDesc.addSimpleAttribute(reservedAttrs, "datasrc");
        Html4DocDesc.addSimpleAttribute(reservedAttrs, "datafld");
        Html4DocDesc.addSimpleAttribute(reservedAttrs, "dataformatas");
        biggerAttrs = new ArrayList(bigAttrs.size() + 3);
        biggerAttrs.addAll(bigAttrs);
        biggerAttrs.addAll(reservedAttrs);
        halignAtt = new HtmlAttributeDesc("align", new String[]{"left", "center", "right", "justify", "char"}, 4);
        valignAtt = new HtmlAttributeDesc("valign", new String[]{"top", "middle", "bottom", "baseline"}, 4);
    }

    protected static void addAddressElement(Map map) {
        String string = "address";
        ArrayList<String> arrayList = new ArrayList<String>(36);
        arrayList.addAll(inlineContent);
        arrayList.add("p");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addBdoElement(Map map) {
        String string = "bdo";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(coreAttrs.size() + 2);
        arrayList.addAll(coreAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "lang");
        arrayList.add(new HtmlAttributeDesc("dir", new String[]{"ltr", "rtl"}, 1));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, inlineContent, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addBodyElement(Map map) {
        String string = "body";
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "onload");
        Html4DocDesc.addSimpleAttribute(arrayList, "onunload");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, bodyContent, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addColElement(Map map, List list) {
        String string = "col";
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 8);
        arrayList.addAll(bigAttrs);
        arrayList.addAll(list);
        Html4DocDesc.addSimpleAttribute(arrayList, "span");
        Html4DocDesc.addSimpleAttribute(arrayList, "width");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addColgroupElement(Map map, List list) {
        String string = "colgroup";
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("col");
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 8);
        arrayList2.addAll(bigAttrs);
        arrayList2.addAll(list);
        Html4DocDesc.addSimpleAttribute(arrayList2, "span");
        Html4DocDesc.addSimpleAttribute(arrayList2, "width");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, arrayList, arrayList2);
        map.put(string, htmlTagDesc);
    }

    protected static void addDdElement(Map map) {
        String string = "dd";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, flowContent, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addDelElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "cite");
        Html4DocDesc.addSimpleAttribute(arrayList, "datetime");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("del", true, true, flowContent, arrayList);
        map.put("del", htmlTagDesc);
    }

    protected static void addDtElement(Map map) {
        String string = "dt";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, inlineContent, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addFieldsetElement(Map map) {
        String string = "fieldset";
        ArrayList<Object> arrayList = new ArrayList<Object>(flowContent.size() + 3);
        arrayList.addAll(flowContent);
        arrayList.add(HtmlSpecialToken.PCDATA);
        arrayList.add("legend");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addInsElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "cite");
        Html4DocDesc.addSimpleAttribute(arrayList, "datetime");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ins", true, true, flowContent, arrayList);
        map.put("ins", htmlTagDesc);
    }

    protected static void addLabelElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 4);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "for");
        Html4DocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4DocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4DocDesc.addSimpleAttribute(arrayList, "onblur");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("label", true, true, inlineContent, arrayList);
        map.put("label", htmlTagDesc);
    }

    protected static void addMapElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 1);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "name");
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.addAll(blockContent);
        arrayList2.add("area");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("map", true, true, arrayList2, arrayList);
        map.put("map", htmlTagDesc);
    }

    protected static void addMetaElement(Map map) {
        ArrayList arrayList = new ArrayList(3);
        Html4DocDesc.addSimpleAttribute(arrayList, "http-equiv");
        Html4DocDesc.addSimpleAttribute(arrayList, "name");
        Html4DocDesc.addRequiredAttribute(arrayList, "content");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("meta", true, false, null, arrayList);
        map.put("meta", htmlTagDesc);
    }

    protected static void addOptgroupElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSelfAttribute(arrayList, "selected");
        Html4DocDesc.addSimpleAttribute(arrayList, "label");
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("option");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("option", true, true, arrayList2, arrayList);
        map.put("option", htmlTagDesc);
    }

    protected static void addOptionElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 4);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSelfAttribute(arrayList, "selected");
        Html4DocDesc.addSelfAttribute(arrayList, "disabled");
        Html4DocDesc.addSimpleAttribute(arrayList, "label");
        Html4DocDesc.addSimpleAttribute(arrayList, "value");
        ArrayList<HtmlSpecialToken> arrayList2 = new ArrayList<HtmlSpecialToken>(1);
        arrayList2.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("option", true, true, arrayList2, arrayList);
        map.put("option", htmlTagDesc);
    }

    protected static void addParamElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(2);
        Html4DocDesc.addRequiredAttribute(arrayList, "name");
        Html4DocDesc.addSimpleAttribute(arrayList, "value");
        arrayList.add(new HtmlAttributeDesc("valuetype", new String[]{"data", "ref", "object"}, 5));
        Html4DocDesc.addSimpleAttribute(arrayList, "type");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("param", true, false, null, arrayList);
        map.put("param", htmlTagDesc);
    }

    protected static void addQElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 1);
        arrayList.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "cite");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("q", true, true, inlineContent, arrayList);
        map.put("q", htmlTagDesc);
    }

    protected static void addSelectElement(Map map) {
        ArrayList arrayList = new ArrayList(biggerAttrs.size() + 10);
        arrayList.addAll(biggerAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList, "name");
        Html4DocDesc.addSimpleAttribute(arrayList, "size");
        Html4DocDesc.addSelfAttribute(arrayList, "multiple");
        Html4DocDesc.addSelfAttribute(arrayList, "disabled");
        Html4DocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4DocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4DocDesc.addSimpleAttribute(arrayList, "onblur");
        Html4DocDesc.addSimpleAttribute(arrayList, "onchange");
        ArrayList<String> arrayList2 = new ArrayList<String>(2);
        arrayList2.add("option");
        arrayList2.add("optgroup");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("select", true, true, arrayList2, arrayList);
        map.put("select", htmlTagDesc);
    }

    protected static void addSpanElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("span", true, true, inlineContent, biggerAttrs);
        map.put("span", htmlTagDesc);
    }

    protected static void addStyleElement(Map map) {
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        ArrayList arrayList2 = new ArrayList(6);
        arrayList2.addAll(i18nAttrs);
        Html4DocDesc.addSimpleAttribute(arrayList2, "type");
        Html4DocDesc.addSimpleAttribute(arrayList2, "media");
        Html4DocDesc.addSimpleAttribute(arrayList2, "title");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("style", true, true, arrayList, arrayList2);
        map.put("style", htmlTagDesc);
    }

    protected static void addSubElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("sub", true, true, inlineContent, bigAttrs);
        map.put("sub", htmlTagDesc);
    }

    protected static void addSupElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("sup", true, true, inlineContent, bigAttrs);
        map.put("sup", htmlTagDesc);
    }

    protected static void addTextareaElement(Map map) {
        ArrayList arrayList = new ArrayList(biggerAttrs.size() + 12);
        Html4DocDesc.addSimpleAttribute(arrayList, "name");
        Html4DocDesc.addSimpleAttribute(arrayList, "rows");
        Html4DocDesc.addSimpleAttribute(arrayList, "cols");
        Html4DocDesc.addSelfAttribute(arrayList, "disabled");
        Html4DocDesc.addSelfAttribute(arrayList, "readonly");
        Html4DocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4DocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4DocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4DocDesc.addSimpleAttribute(arrayList, "onblur");
        Html4DocDesc.addSimpleAttribute(arrayList, "onselect");
        Html4DocDesc.addSimpleAttribute(arrayList, "onchange");
        ArrayList<HtmlSpecialToken> arrayList2 = new ArrayList<HtmlSpecialToken>(1);
        arrayList2.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("textarea", true, true, arrayList2, arrayList);
        map.put("textarea", htmlTagDesc);
    }

    protected static void addTbodyElement(Map map, List list) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("tr");
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 8);
        arrayList2.addAll(bigAttrs);
        arrayList2.addAll(list);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("tbody", false, false, arrayList, arrayList2);
        map.put("tbody", htmlTagDesc);
    }

    protected static void addTdElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("td", true, false, flowContent, thtdAtts);
        map.put("td", htmlTagDesc);
    }

    protected static void addTfootElement(Map map, List list) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("tr");
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 8);
        arrayList2.addAll(bigAttrs);
        arrayList2.addAll(list);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("tfoot", true, false, arrayList, arrayList2);
        map.put("tfoot", htmlTagDesc);
    }

    protected static void addThElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("th", true, false, flowContent, thtdAtts);
        map.put("th", htmlTagDesc);
    }

    protected static void addTheadElement(Map map, List list) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("tr");
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 8);
        arrayList2.addAll(bigAttrs);
        arrayList2.addAll(list);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("thead", true, false, arrayList, arrayList2);
        map.put("thead", htmlTagDesc);
    }

    protected static void addTitleElement(Map map) {
        String string = "title";
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, i18nAttrs);
        map.put(string, htmlTagDesc);
    }
}

