/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_USEOFLOGACCESS_H_
#define OPENDRIM_USEOFLOGACCESS_H_

#include "OpenDRIM_RecordLogPackage_Common.h"

#include "OpenDRIM_UseOfLog.h"
#include "assocOpenDRIM_UseOfLog.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_load(const CMPIBroker* broker, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_unload(string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_UseOfLog>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_UseOfLog& instance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_UseOfLog& newInstance, const OpenDRIM_UseOfLog& oldInstance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_UseOfLog& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_UseOfLog& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_UseOfLog>& OpenDRIM_UseOfLog_instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_UseOfLog>& OpenDRIM_UseOfLog_instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_UseOfLog_populate(OpenDRIM_UseOfLog& instance, string& errorMessage);

#endif /*OPENDRIM_USEOFLOGACCESS_H_*/
