#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Darkside Detective
# send your bug reports to contact@dotslashplay.it
###

script_version=20241112.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='the-darkside-detective'
GAME_NAME='The Darkside Detective'

ARCHIVE_BASE_0_NAME='the_darkside_detective_2_3_0_1448r_49520.sh'
ARCHIVE_BASE_0_MD5='df6e6205d0d4fc64fc46f5be68f1afce'
ARCHIVE_BASE_0_SIZE='1108998'
ARCHIVE_BASE_0_VERSION='2.3.0.1448r-gog49520'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_darkside_detective'

UNITY3D_NAME='thedarksidedetective'
## TODO: Check if the Stadia libraries could be dropped
UNITY3D_PLUGINS='
libunitystadia.so
libunitystadia_preview.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc++abi.so.1
libc.so.6
libdl.so.2
libgcc_s.so.1
libggp.so
libm.so.6
libpthread.so.0
libpulse.so.0
librt.so.1
libvulkan.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
