struct Precomp {
	float alpha2_sum;
	float beta2_sum;
	float alphabeta_sum;
	float factor;
};

static const SQUISH_ALIGN_16 Precomp s_threeElement[153] = {
	{ 0.000000f, 16.000000f, 0.000000f, FLT_MAX }, // 0 (0 0 16)
	{ 0.250000f, 15.250000f, 0.250000f, 0.266667f }, // 1 (0 1 15)
	{ 0.500000f, 14.500000f, 0.500000f, 0.142857f }, // 2 (0 2 14)
	{ 0.750000f, 13.750000f, 0.750000f, 0.102564f }, // 3 (0 3 13)
	{ 1.000000f, 13.000000f, 1.000000f, 0.083333f }, // 4 (0 4 12)
	{ 1.250000f, 12.250000f, 1.250000f, 0.072727f }, // 5 (0 5 11)
	{ 1.500000f, 11.500000f, 1.500000f, 0.066667f }, // 6 (0 6 10)
	{ 1.750000f, 10.750000f, 1.750000f, 0.063492f }, // 7 (0 7 9)
	{ 2.000000f, 10.000000f, 2.000000f, 0.062500f }, // 8 (0 8 8)
	{ 2.250000f, 9.250000f, 2.250000f, 0.063492f }, // 9 (0 9 7)
	{ 2.500000f, 8.500000f, 2.500000f, 0.066667f }, // 10 (0 10 6)
	{ 2.750000f, 7.750000f, 2.750000f, 0.072727f }, // 11 (0 11 5)
	{ 3.000000f, 7.000000f, 3.000000f, 0.083333f }, // 12 (0 12 4)
	{ 3.250000f, 6.250000f, 3.250000f, 0.102564f }, // 13 (0 13 3)
	{ 3.500000f, 5.500000f, 3.500000f, 0.142857f }, // 14 (0 14 2)
	{ 3.750000f, 4.750000f, 3.750000f, 0.266667f }, // 15 (0 15 1)
	{ 4.000000f, 4.000000f, 4.000000f, FLT_MAX }, // 16 (0 16 0)
	{ 1.000000f, 15.000000f, 0.000000f, 0.066667f }, // 17 (1 0 15)
	{ 1.250000f, 14.250000f, 0.250000f, 0.056338f }, // 18 (1 1 14)
	{ 1.500000f, 13.500000f, 0.500000f, 0.050000f }, // 19 (1 2 13)
	{ 1.750000f, 12.750000f, 0.750000f, 0.045977f }, // 20 (1 3 12)
	{ 2.000000f, 12.000000f, 1.000000f, 0.043478f }, // 21 (1 4 11)
	{ 2.250000f, 11.250000f, 1.250000f, 0.042105f }, // 22 (1 5 10)
	{ 2.500000f, 10.500000f, 1.500000f, 0.041667f }, // 23 (1 6 9)
	{ 2.750000f, 9.750000f, 1.750000f, 0.042105f }, // 24 (1 7 8)
	{ 3.000000f, 9.000000f, 2.000000f, 0.043478f }, // 25 (1 8 7)
	{ 3.250000f, 8.250000f, 2.250000f, 0.045977f }, // 26 (1 9 6)
	{ 3.500000f, 7.500000f, 2.500000f, 0.050000f }, // 27 (1 10 5)
	{ 3.750000f, 6.750000f, 2.750000f, 0.056338f }, // 28 (1 11 4)
	{ 4.000000f, 6.000000f, 3.000000f, 0.066667f }, // 29 (1 12 3)
	{ 4.250000f, 5.250000f, 3.250000f, 0.085106f }, // 30 (1 13 2)
	{ 4.500000f, 4.500000f, 3.500000f, 0.125000f }, // 31 (1 14 1)
	{ 4.750000f, 3.750000f, 3.750000f, 0.266667f }, // 32 (1 15 0)
	{ 2.000000f, 14.000000f, 0.000000f, 0.035714f }, // 33 (2 0 14)
	{ 2.250000f, 13.250000f, 0.250000f, 0.033613f }, // 34 (2 1 13)
	{ 2.500000f, 12.500000f, 0.500000f, 0.032258f }, // 35 (2 2 12)
	{ 2.750000f, 11.750000f, 0.750000f, 0.031496f }, // 36 (2 3 11)
	{ 3.000000f, 11.000000f, 1.000000f, 0.031250f }, // 37 (2 4 10)
	{ 3.250000f, 10.250000f, 1.250000f, 0.031496f }, // 38 (2 5 9)
	{ 3.500000f, 9.500000f, 1.500000f, 0.032258f }, // 39 (2 6 8)
	{ 3.750000f, 8.750000f, 1.750000f, 0.033613f }, // 40 (2 7 7)
	{ 4.000000f, 8.000000f, 2.000000f, 0.035714f }, // 41 (2 8 6)
	{ 4.250000f, 7.250000f, 2.250000f, 0.038835f }, // 42 (2 9 5)
	{ 4.500000f, 6.500000f, 2.500000f, 0.043478f }, // 43 (2 10 4)
	{ 4.750000f, 5.750000f, 2.750000f, 0.050633f }, // 44 (2 11 3)
	{ 5.000000f, 5.000000f, 3.000000f, 0.062500f }, // 45 (2 12 2)
	{ 5.250000f, 4.250000f, 3.250000f, 0.085106f }, // 46 (2 13 1)
	{ 5.500000f, 3.500000f, 3.500000f, 0.142857f }, // 47 (2 14 0)
	{ 3.000000f, 13.000000f, 0.000000f, 0.025641f }, // 48 (3 0 13)
	{ 3.250000f, 12.250000f, 0.250000f, 0.025157f }, // 49 (3 1 12)
	{ 3.500000f, 11.500000f, 0.500000f, 0.025000f }, // 50 (3 2 11)
	{ 3.750000f, 10.750000f, 0.750000f, 0.025157f }, // 51 (3 3 10)
	{ 4.000000f, 10.000000f, 1.000000f, 0.025641f }, // 52 (3 4 9)
	{ 4.250000f, 9.250000f, 1.250000f, 0.026490f }, // 53 (3 5 8)
	{ 4.500000f, 8.500000f, 1.500000f, 0.027778f }, // 54 (3 6 7)
	{ 4.750000f, 7.750000f, 1.750000f, 0.029630f }, // 55 (3 7 6)
	{ 5.000000f, 7.000000f, 2.000000f, 0.032258f }, // 56 (3 8 5)
	{ 5.250000f, 6.250000f, 2.250000f, 0.036036f }, // 57 (3 9 4)
	{ 5.500000f, 5.500000f, 2.500000f, 0.041667f }, // 58 (3 10 3)
	{ 5.750000f, 4.750000f, 2.750000f, 0.050633f }, // 59 (3 11 2)
	{ 6.000000f, 4.000000f, 3.000000f, 0.066667f }, // 60 (3 12 1)
	{ 6.250000f, 3.250000f, 3.250000f, 0.102564f }, // 61 (3 13 0)
	{ 4.000000f, 12.000000f, 0.000000f, 0.020833f }, // 62 (4 0 12)
	{ 4.250000f, 11.250000f, 0.250000f, 0.020942f }, // 63 (4 1 11)
	{ 4.500000f, 10.500000f, 0.500000f, 0.021277f }, // 64 (4 2 10)
	{ 4.750000f, 9.750000f, 0.750000f, 0.021858f }, // 65 (4 3 9)
	{ 5.000000f, 9.000000f, 1.000000f, 0.022727f }, // 66 (4 4 8)
	{ 5.250000f, 8.250000f, 1.250000f, 0.023952f }, // 67 (4 5 7)
	{ 5.500000f, 7.500000f, 1.500000f, 0.025641f }, // 68 (4 6 6)
	{ 5.750000f, 6.750000f, 1.750000f, 0.027972f }, // 69 (4 7 5)
	{ 6.000000f, 6.000000f, 2.000000f, 0.031250f }, // 70 (4 8 4)
	{ 6.250000f, 5.250000f, 2.250000f, 0.036036f }, // 71 (4 9 3)
	{ 6.500000f, 4.500000f, 2.500000f, 0.043478f }, // 72 (4 10 2)
	{ 6.750000f, 3.750000f, 2.750000f, 0.056338f }, // 73 (4 11 1)
	{ 7.000000f, 3.000000f, 3.000000f, 0.083333f }, // 74 (4 12 0)
	{ 5.000000f, 11.000000f, 0.000000f, 0.018182f }, // 75 (5 0 11)
	{ 5.250000f, 10.250000f, 0.250000f, 0.018605f }, // 76 (5 1 10)
	{ 5.500000f, 9.500000f, 0.500000f, 0.019231f }, // 77 (5 2 9)
	{ 5.750000f, 8.750000f, 0.750000f, 0.020101f }, // 78 (5 3 8)
	{ 6.000000f, 8.000000f, 1.000000f, 0.021277f }, // 79 (5 4 7)
	{ 6.250000f, 7.250000f, 1.250000f, 0.022857f }, // 80 (5 5 6)
	{ 6.500000f, 6.500000f, 1.500000f, 0.025000f }, // 81 (5 6 5)
	{ 6.750000f, 5.750000f, 1.750000f, 0.027972f }, // 82 (5 7 4)
	{ 7.000000f, 5.000000f, 2.000000f, 0.032258f }, // 83 (5 8 3)
	{ 7.250000f, 4.250000f, 2.250000f, 0.038835f }, // 84 (5 9 2)
	{ 7.500000f, 3.500000f, 2.500000f, 0.050000f }, // 85 (5 10 1)
	{ 7.750000f, 2.750000f, 2.750000f, 0.072727f }, // 86 (5 11 0)
	{ 6.000000f, 10.000000f, 0.000000f, 0.016667f }, // 87 (6 0 10)
	{ 6.250000f, 9.250000f, 0.250000f, 0.017316f }, // 88 (6 1 9)
	{ 6.500000f, 8.500000f, 0.500000f, 0.018182f }, // 89 (6 2 8)
	{ 6.750000f, 7.750000f, 0.750000f, 0.019324f }, // 90 (6 3 7)
	{ 7.000000f, 7.000000f, 1.000000f, 0.020833f }, // 91 (6 4 6)
	{ 7.250000f, 6.250000f, 1.250000f, 0.022857f }, // 92 (6 5 5)
	{ 7.500000f, 5.500000f, 1.500000f, 0.025641f }, // 93 (6 6 4)
	{ 7.750000f, 4.750000f, 1.750000f, 0.029630f }, // 94 (6 7 3)
	{ 8.000000f, 4.000000f, 2.000000f, 0.035714f }, // 95 (6 8 2)
	{ 8.250000f, 3.250000f, 2.250000f, 0.045977f }, // 96 (6 9 1)
	{ 8.500000f, 2.500000f, 2.500000f, 0.066667f }, // 97 (6 10 0)
	{ 7.000000f, 9.000000f, 0.000000f, 0.015873f }, // 98 (7 0 9)
	{ 7.250000f, 8.250000f, 0.250000f, 0.016736f }, // 99 (7 1 8)
	{ 7.500000f, 7.500000f, 0.500000f, 0.017857f }, // 100 (7 2 7)
	{ 7.750000f, 6.750000f, 0.750000f, 0.019324f }, // 101 (7 3 6)
	{ 8.000000f, 6.000000f, 1.000000f, 0.021277f }, // 102 (7 4 5)
	{ 8.250000f, 5.250000f, 1.250000f, 0.023952f }, // 103 (7 5 4)
	{ 8.500000f, 4.500000f, 1.500000f, 0.027778f }, // 104 (7 6 3)
	{ 8.750000f, 3.750000f, 1.750000f, 0.033613f }, // 105 (7 7 2)
	{ 9.000000f, 3.000000f, 2.000000f, 0.043478f }, // 106 (7 8 1)
	{ 9.250000f, 2.250000f, 2.250000f, 0.063492f }, // 107 (7 9 0)
	{ 8.000000f, 8.000000f, 0.000000f, 0.015625f }, // 108 (8 0 8)
	{ 8.250000f, 7.250000f, 0.250000f, 0.016736f }, // 109 (8 1 7)
	{ 8.500000f, 6.500000f, 0.500000f, 0.018182f }, // 110 (8 2 6)
	{ 8.750000f, 5.750000f, 0.750000f, 0.020101f }, // 111 (8 3 5)
	{ 9.000000f, 5.000000f, 1.000000f, 0.022727f }, // 112 (8 4 4)
	{ 9.250000f, 4.250000f, 1.250000f, 0.026490f }, // 113 (8 5 3)
	{ 9.500000f, 3.500000f, 1.500000f, 0.032258f }, // 114 (8 6 2)
	{ 9.750000f, 2.750000f, 1.750000f, 0.042105f }, // 115 (8 7 1)
	{ 10.000000f, 2.000000f, 2.000000f, 0.062500f }, // 116 (8 8 0)
	{ 9.000000f, 7.000000f, 0.000000f, 0.015873f }, // 117 (9 0 7)
	{ 9.250000f, 6.250000f, 0.250000f, 0.017316f }, // 118 (9 1 6)
	{ 9.500000f, 5.500000f, 0.500000f, 0.019231f }, // 119 (9 2 5)
	{ 9.750000f, 4.750000f, 0.750000f, 0.021858f }, // 120 (9 3 4)
	{ 10.000000f, 4.000000f, 1.000000f, 0.025641f }, // 121 (9 4 3)
	{ 10.250000f, 3.250000f, 1.250000f, 0.031496f }, // 122 (9 5 2)
	{ 10.500000f, 2.500000f, 1.500000f, 0.041667f }, // 123 (9 6 1)
	{ 10.750000f, 1.750000f, 1.750000f, 0.063492f }, // 124 (9 7 0)
	{ 10.000000f, 6.000000f, 0.000000f, 0.016667f }, // 125 (10 0 6)
	{ 10.250000f, 5.250000f, 0.250000f, 0.018605f }, // 126 (10 1 5)
	{ 10.500000f, 4.500000f, 0.500000f, 0.021277f }, // 127 (10 2 4)
	{ 10.750000f, 3.750000f, 0.750000f, 0.025157f }, // 128 (10 3 3)
	{ 11.000000f, 3.000000f, 1.000000f, 0.031250f }, // 129 (10 4 2)
	{ 11.250000f, 2.250000f, 1.250000f, 0.042105f }, // 130 (10 5 1)
	{ 11.500000f, 1.500000f, 1.500000f, 0.066667f }, // 131 (10 6 0)
	{ 11.000000f, 5.000000f, 0.000000f, 0.018182f }, // 132 (11 0 5)
	{ 11.250000f, 4.250000f, 0.250000f, 0.020942f }, // 133 (11 1 4)
	{ 11.500000f, 3.500000f, 0.500000f, 0.025000f }, // 134 (11 2 3)
	{ 11.750000f, 2.750000f, 0.750000f, 0.031496f }, // 135 (11 3 2)
	{ 12.000000f, 2.000000f, 1.000000f, 0.043478f }, // 136 (11 4 1)
	{ 12.250000f, 1.250000f, 1.250000f, 0.072727f }, // 137 (11 5 0)
	{ 12.000000f, 4.000000f, 0.000000f, 0.020833f }, // 138 (12 0 4)
	{ 12.250000f, 3.250000f, 0.250000f, 0.025157f }, // 139 (12 1 3)
	{ 12.500000f, 2.500000f, 0.500000f, 0.032258f }, // 140 (12 2 2)
	{ 12.750000f, 1.750000f, 0.750000f, 0.045977f }, // 141 (12 3 1)
	{ 13.000000f, 1.000000f, 1.000000f, 0.083333f }, // 142 (12 4 0)
	{ 13.000000f, 3.000000f, 0.000000f, 0.025641f }, // 143 (13 0 3)
	{ 13.250000f, 2.250000f, 0.250000f, 0.033613f }, // 144 (13 1 2)
	{ 13.500000f, 1.500000f, 0.500000f, 0.050000f }, // 145 (13 2 1)
	{ 13.750000f, 0.750000f, 0.750000f, 0.102564f }, // 146 (13 3 0)
	{ 14.000000f, 2.000000f, 0.000000f, 0.035714f }, // 147 (14 0 2)
	{ 14.250000f, 1.250000f, 0.250000f, 0.056338f }, // 148 (14 1 1)
	{ 14.500000f, 0.500000f, 0.500000f, 0.142857f }, // 149 (14 2 0)
	{ 15.000000f, 1.000000f, 0.000000f, 0.066667f }, // 150 (15 0 1)
	{ 15.250000f, 0.250000f, 0.250000f, 0.266667f }, // 151 (15 1 0)
	{ 16.000000f, 0.000000f, 0.000000f, FLT_MAX }, // 152 (16 0 0)
}; // 153 three cluster elements

static const SQUISH_ALIGN_16 Precomp s_fourElement[969] = {
	{ 0.000000f, 16.000000f, 0.000000f, FLT_MAX }, // 0 (0 0 0 16)
	{ 0.111111f, 15.444445f, 0.222222f, 0.600000f }, // 1 (0 0 1 15)
	{ 0.222222f, 14.888889f, 0.444444f, 0.321429f }, // 2 (0 0 2 14)
	{ 0.333333f, 14.333333f, 0.666667f, 0.230769f }, // 3 (0 0 3 13)
	{ 0.444444f, 13.777778f, 0.888889f, 0.187500f }, // 4 (0 0 4 12)
	{ 0.555556f, 13.222222f, 1.111111f, 0.163636f }, // 5 (0 0 5 11)
	{ 0.666667f, 12.666667f, 1.333333f, 0.150000f }, // 6 (0 0 6 10)
	{ 0.777778f, 12.111111f, 1.555556f, 0.142857f }, // 7 (0 0 7 9)
	{ 0.888889f, 11.555555f, 1.777778f, 0.140625f }, // 8 (0 0 8 8)
	{ 1.000000f, 11.000000f, 2.000000f, 0.142857f }, // 9 (0 0 9 7)
	{ 1.111111f, 10.444445f, 2.222222f, 0.150000f }, // 10 (0 0 10 6)
	{ 1.222222f, 9.888889f, 2.444444f, 0.163636f }, // 11 (0 0 11 5)
	{ 1.333333f, 9.333333f, 2.666667f, 0.187500f }, // 12 (0 0 12 4)
	{ 1.444444f, 8.777778f, 2.888889f, 0.230769f }, // 13 (0 0 13 3)
	{ 1.555556f, 8.222222f, 3.111111f, 0.321429f }, // 14 (0 0 14 2)
	{ 1.666667f, 7.666667f, 3.333333f, 0.600000f }, // 15 (0 0 15 1)
	{ 1.777778f, 7.111111f, 3.555556f, FLT_MAX }, // 16 (0 0 16 0)
	{ 0.444444f, 15.111111f, 0.222222f, 0.150000f }, // 17 (0 1 0 15)
	{ 0.555556f, 14.555555f, 0.444444f, 0.126761f }, // 18 (0 1 1 14)
	{ 0.666667f, 14.000000f, 0.666667f, 0.112500f }, // 19 (0 1 2 13)
	{ 0.777778f, 13.444445f, 0.888889f, 0.103448f }, // 20 (0 1 3 12)
	{ 0.888889f, 12.888889f, 1.111111f, 0.097826f }, // 21 (0 1 4 11)
	{ 1.000000f, 12.333333f, 1.333333f, 0.094737f }, // 22 (0 1 5 10)
	{ 1.111111f, 11.777778f, 1.555556f, 0.093750f }, // 23 (0 1 6 9)
	{ 1.222222f, 11.222222f, 1.777778f, 0.094737f }, // 24 (0 1 7 8)
	{ 1.333333f, 10.666667f, 2.000000f, 0.097826f }, // 25 (0 1 8 7)
	{ 1.444444f, 10.111111f, 2.222222f, 0.103448f }, // 26 (0 1 9 6)
	{ 1.555556f, 9.555555f, 2.444444f, 0.112500f }, // 27 (0 1 10 5)
	{ 1.666667f, 9.000000f, 2.666667f, 0.126761f }, // 28 (0 1 11 4)
	{ 1.777778f, 8.444445f, 2.888889f, 0.150000f }, // 29 (0 1 12 3)
	{ 1.888889f, 7.888889f, 3.111111f, 0.191489f }, // 30 (0 1 13 2)
	{ 2.000000f, 7.333333f, 3.333333f, 0.281250f }, // 31 (0 1 14 1)
	{ 2.111111f, 6.777778f, 3.555556f, 0.600000f }, // 32 (0 1 15 0)
	{ 0.888889f, 14.222222f, 0.444444f, 0.080357f }, // 33 (0 2 0 14)
	{ 1.000000f, 13.666667f, 0.666667f, 0.075630f }, // 34 (0 2 1 13)
	{ 1.111111f, 13.111111f, 0.888889f, 0.072581f }, // 35 (0 2 2 12)
	{ 1.222222f, 12.555555f, 1.111111f, 0.070866f }, // 36 (0 2 3 11)
	{ 1.333333f, 12.000000f, 1.333333f, 0.070313f }, // 37 (0 2 4 10)
	{ 1.444444f, 11.444445f, 1.555556f, 0.070866f }, // 38 (0 2 5 9)
	{ 1.555556f, 10.888889f, 1.777778f, 0.072581f }, // 39 (0 2 6 8)
	{ 1.666667f, 10.333333f, 2.000000f, 0.075630f }, // 40 (0 2 7 7)
	{ 1.777778f, 9.777778f, 2.222222f, 0.080357f }, // 41 (0 2 8 6)
	{ 1.888889f, 9.222222f, 2.444444f, 0.087379f }, // 42 (0 2 9 5)
	{ 2.000000f, 8.666667f, 2.666667f, 0.097826f }, // 43 (0 2 10 4)
	{ 2.111111f, 8.111111f, 2.888889f, 0.113924f }, // 44 (0 2 11 3)
	{ 2.222222f, 7.555556f, 3.111111f, 0.140625f }, // 45 (0 2 12 2)
	{ 2.333333f, 7.000000f, 3.333333f, 0.191489f }, // 46 (0 2 13 1)
	{ 2.444444f, 6.444445f, 3.555556f, 0.321429f }, // 47 (0 2 14 0)
	{ 1.333333f, 13.333333f, 0.666667f, 0.057692f }, // 48 (0 3 0 13)
	{ 1.444444f, 12.777778f, 0.888889f, 0.056604f }, // 49 (0 3 1 12)
	{ 1.555556f, 12.222222f, 1.111111f, 0.056250f }, // 50 (0 3 2 11)
	{ 1.666667f, 11.666667f, 1.333333f, 0.056604f }, // 51 (0 3 3 10)
	{ 1.777778f, 11.111111f, 1.555556f, 0.057692f }, // 52 (0 3 4 9)
	{ 1.888889f, 10.555555f, 1.777778f, 0.059603f }, // 53 (0 3 5 8)
	{ 2.000000f, 10.000000f, 2.000000f, 0.062500f }, // 54 (0 3 6 7)
	{ 2.111111f, 9.444445f, 2.222222f, 0.066667f }, // 55 (0 3 7 6)
	{ 2.222222f, 8.888889f, 2.444444f, 0.072581f }, // 56 (0 3 8 5)
	{ 2.333333f, 8.333333f, 2.666667f, 0.081081f }, // 57 (0 3 9 4)
	{ 2.444444f, 7.777778f, 2.888889f, 0.093750f }, // 58 (0 3 10 3)
	{ 2.555556f, 7.222222f, 3.111111f, 0.113924f }, // 59 (0 3 11 2)
	{ 2.666667f, 6.666667f, 3.333333f, 0.150000f }, // 60 (0 3 12 1)
	{ 2.777778f, 6.111111f, 3.555556f, 0.230769f }, // 61 (0 3 13 0)
	{ 1.777778f, 12.444445f, 0.888889f, 0.046875f }, // 62 (0 4 0 12)
	{ 1.888889f, 11.888889f, 1.111111f, 0.047120f }, // 63 (0 4 1 11)
	{ 2.000000f, 11.333333f, 1.333333f, 0.047872f }, // 64 (0 4 2 10)
	{ 2.111111f, 10.777778f, 1.555556f, 0.049180f }, // 65 (0 4 3 9)
	{ 2.222222f, 10.222222f, 1.777778f, 0.051136f }, // 66 (0 4 4 8)
	{ 2.333333f, 9.666667f, 2.000000f, 0.053892f }, // 67 (0 4 5 7)
	{ 2.444444f, 9.111111f, 2.222222f, 0.057692f }, // 68 (0 4 6 6)
	{ 2.555556f, 8.555555f, 2.444444f, 0.062937f }, // 69 (0 4 7 5)
	{ 2.666667f, 8.000000f, 2.666667f, 0.070313f }, // 70 (0 4 8 4)
	{ 2.777778f, 7.444445f, 2.888889f, 0.081081f }, // 71 (0 4 9 3)
	{ 2.888889f, 6.888889f, 3.111111f, 0.097826f }, // 72 (0 4 10 2)
	{ 3.000000f, 6.333333f, 3.333333f, 0.126761f }, // 73 (0 4 11 1)
	{ 3.111111f, 5.777778f, 3.555556f, 0.187500f }, // 74 (0 4 12 0)
	{ 2.222222f, 11.555555f, 1.111111f, 0.040909f }, // 75 (0 5 0 11)
	{ 2.333333f, 11.000000f, 1.333333f, 0.041860f }, // 76 (0 5 1 10)
	{ 2.444444f, 10.444445f, 1.555556f, 0.043269f }, // 77 (0 5 2 9)
	{ 2.555556f, 9.888889f, 1.777778f, 0.045226f }, // 78 (0 5 3 8)
	{ 2.666667f, 9.333333f, 2.000000f, 0.047872f }, // 79 (0 5 4 7)
	{ 2.777778f, 8.777778f, 2.222222f, 0.051429f }, // 80 (0 5 5 6)
	{ 2.888889f, 8.222222f, 2.444444f, 0.056250f }, // 81 (0 5 6 5)
	{ 3.000000f, 7.666667f, 2.666667f, 0.062937f }, // 82 (0 5 7 4)
	{ 3.111111f, 7.111111f, 2.888889f, 0.072581f }, // 83 (0 5 8 3)
	{ 3.222222f, 6.555556f, 3.111111f, 0.087379f }, // 84 (0 5 9 2)
	{ 3.333333f, 6.000000f, 3.333333f, 0.112500f }, // 85 (0 5 10 1)
	{ 3.444444f, 5.444445f, 3.555556f, 0.163636f }, // 86 (0 5 11 0)
	{ 2.666667f, 10.666667f, 1.333333f, 0.037500f }, // 87 (0 6 0 10)
	{ 2.777778f, 10.111111f, 1.555556f, 0.038961f }, // 88 (0 6 1 9)
	{ 2.888889f, 9.555555f, 1.777778f, 0.040909f }, // 89 (0 6 2 8)
	{ 3.000000f, 9.000000f, 2.000000f, 0.043478f }, // 90 (0 6 3 7)
	{ 3.111111f, 8.444445f, 2.222222f, 0.046875f }, // 91 (0 6 4 6)
	{ 3.222222f, 7.888889f, 2.444444f, 0.051429f }, // 92 (0 6 5 5)
	{ 3.333333f, 7.333333f, 2.666667f, 0.057692f }, // 93 (0 6 6 4)
	{ 3.444444f, 6.777778f, 2.888889f, 0.066667f }, // 94 (0 6 7 3)
	{ 3.555556f, 6.222222f, 3.111111f, 0.080357f }, // 95 (0 6 8 2)
	{ 3.666667f, 5.666667f, 3.333333f, 0.103448f }, // 96 (0 6 9 1)
	{ 3.777778f, 5.111111f, 3.555556f, 0.150000f }, // 97 (0 6 10 0)
	{ 3.111111f, 9.777778f, 1.555556f, 0.035714f }, // 98 (0 7 0 9)
	{ 3.222222f, 9.222222f, 1.777778f, 0.037657f }, // 99 (0 7 1 8)
	{ 3.333333f, 8.666667f, 2.000000f, 0.040179f }, // 100 (0 7 2 7)
	{ 3.444444f, 8.111111f, 2.222222f, 0.043478f }, // 101 (0 7 3 6)
	{ 3.555556f, 7.555555f, 2.444444f, 0.047872f }, // 102 (0 7 4 5)
	{ 3.666667f, 7.000000f, 2.666667f, 0.053892f }, // 103 (0 7 5 4)
	{ 3.777778f, 6.444445f, 2.888889f, 0.062500f }, // 104 (0 7 6 3)
	{ 3.888889f, 5.888889f, 3.111111f, 0.075630f }, // 105 (0 7 7 2)
	{ 4.000000f, 5.333333f, 3.333333f, 0.097826f }, // 106 (0 7 8 1)
	{ 4.111111f, 4.777778f, 3.555556f, 0.142857f }, // 107 (0 7 9 0)
	{ 3.555556f, 8.888889f, 1.777778f, 0.035156f }, // 108 (0 8 0 8)
	{ 3.666667f, 8.333333f, 2.000000f, 0.037657f }, // 109 (0 8 1 7)
	{ 3.777778f, 7.777778f, 2.222222f, 0.040909f }, // 110 (0 8 2 6)
	{ 3.888889f, 7.222222f, 2.444444f, 0.045226f }, // 111 (0 8 3 5)
	{ 4.000000f, 6.666667f, 2.666667f, 0.051136f }, // 112 (0 8 4 4)
	{ 4.111111f, 6.111111f, 2.888889f, 0.059603f }, // 113 (0 8 5 3)
	{ 4.222222f, 5.555555f, 3.111111f, 0.072581f }, // 114 (0 8 6 2)
	{ 4.333333f, 5.000000f, 3.333333f, 0.094737f }, // 115 (0 8 7 1)
	{ 4.444445f, 4.444445f, 3.555556f, 0.140625f }, // 116 (0 8 8 0)
	{ 4.000000f, 8.000000f, 2.000000f, 0.035714f }, // 117 (0 9 0 7)
	{ 4.111111f, 7.444445f, 2.222222f, 0.038961f }, // 118 (0 9 1 6)
	{ 4.222222f, 6.888889f, 2.444444f, 0.043269f }, // 119 (0 9 2 5)
	{ 4.333333f, 6.333333f, 2.666667f, 0.049180f }, // 120 (0 9 3 4)
	{ 4.444445f, 5.777778f, 2.888889f, 0.057692f }, // 121 (0 9 4 3)
	{ 4.555556f, 5.222222f, 3.111111f, 0.070866f }, // 122 (0 9 5 2)
	{ 4.666667f, 4.666667f, 3.333333f, 0.093750f }, // 123 (0 9 6 1)
	{ 4.777778f, 4.111111f, 3.555556f, 0.142857f }, // 124 (0 9 7 0)
	{ 4.444445f, 7.111111f, 2.222222f, 0.037500f }, // 125 (0 10 0 6)
	{ 4.555556f, 6.555555f, 2.444444f, 0.041860f }, // 126 (0 10 1 5)
	{ 4.666667f, 6.000000f, 2.666667f, 0.047872f }, // 127 (0 10 2 4)
	{ 4.777778f, 5.444445f, 2.888889f, 0.056604f }, // 128 (0 10 3 3)
	{ 4.888889f, 4.888889f, 3.111111f, 0.070313f }, // 129 (0 10 4 2)
	{ 5.000000f, 4.333333f, 3.333333f, 0.094737f }, // 130 (0 10 5 1)
	{ 5.111111f, 3.777778f, 3.555556f, 0.150000f }, // 131 (0 10 6 0)
	{ 4.888889f, 6.222222f, 2.444444f, 0.040909f }, // 132 (0 11 0 5)
	{ 5.000000f, 5.666667f, 2.666667f, 0.047120f }, // 133 (0 11 1 4)
	{ 5.111111f, 5.111111f, 2.888889f, 0.056250f }, // 134 (0 11 2 3)
	{ 5.222222f, 4.555555f, 3.111111f, 0.070866f }, // 135 (0 11 3 2)
	{ 5.333333f, 4.000000f, 3.333333f, 0.097826f }, // 136 (0 11 4 1)
	{ 5.444445f, 3.444444f, 3.555556f, 0.163636f }, // 137 (0 11 5 0)
	{ 5.333333f, 5.333333f, 2.666667f, 0.046875f }, // 138 (0 12 0 4)
	{ 5.444445f, 4.777778f, 2.888889f, 0.056604f }, // 139 (0 12 1 3)
	{ 5.555556f, 4.222222f, 3.111111f, 0.072581f }, // 140 (0 12 2 2)
	{ 5.666667f, 3.666667f, 3.333333f, 0.103448f }, // 141 (0 12 3 1)
	{ 5.777778f, 3.111111f, 3.555556f, 0.187500f }, // 142 (0 12 4 0)
	{ 5.777778f, 4.444445f, 2.888889f, 0.057692f }, // 143 (0 13 0 3)
	{ 5.888889f, 3.888889f, 3.111111f, 0.075630f }, // 144 (0 13 1 2)
	{ 6.000000f, 3.333333f, 3.333333f, 0.112500f }, // 145 (0 13 2 1)
	{ 6.111111f, 2.777778f, 3.555556f, 0.230769f }, // 146 (0 13 3 0)
	{ 6.222222f, 3.555556f, 3.111111f, 0.080357f }, // 147 (0 14 0 2)
	{ 6.333333f, 3.000000f, 3.333333f, 0.126761f }, // 148 (0 14 1 1)
	{ 6.444445f, 2.444444f, 3.555556f, 0.321429f }, // 149 (0 14 2 0)
	{ 6.666667f, 2.666667f, 3.333333f, 0.150000f }, // 150 (0 15 0 1)
	{ 6.777778f, 2.111111f, 3.555556f, 0.600000f }, // 151 (0 15 1 0)
	{ 7.111111f, 1.777778f, 3.555556f, FLT_MAX }, // 152 (0 16 0 0)
	{ 1.000000f, 15.000000f, 0.000000f, 0.066667f }, // 153 (1 0 0 15)
	{ 1.111111f, 14.444445f, 0.222222f, 0.062500f }, // 154 (1 0 1 14)
	{ 1.222222f, 13.888889f, 0.444444f, 0.059603f }, // 155 (1 0 2 13)
	{ 1.333333f, 13.333333f, 0.666667f, 0.057692f }, // 156 (1 0 3 12)
	{ 1.444444f, 12.777778f, 0.888889f, 0.056604f }, // 157 (1 0 4 11)
	{ 1.555556f, 12.222222f, 1.111111f, 0.056250f }, // 158 (1 0 5 10)
	{ 1.666667f, 11.666667f, 1.333333f, 0.056604f }, // 159 (1 0 6 9)
	{ 1.777778f, 11.111111f, 1.555556f, 0.057692f }, // 160 (1 0 7 8)
	{ 1.888889f, 10.555555f, 1.777778f, 0.059603f }, // 161 (1 0 8 7)
	{ 2.000000f, 10.000000f, 2.000000f, 0.062500f }, // 162 (1 0 9 6)
	{ 2.111111f, 9.444445f, 2.222222f, 0.066667f }, // 163 (1 0 10 5)
	{ 2.222222f, 8.888889f, 2.444444f, 0.072581f }, // 164 (1 0 11 4)
	{ 2.333333f, 8.333333f, 2.666667f, 0.081081f }, // 165 (1 0 12 3)
	{ 2.444444f, 7.777778f, 2.888889f, 0.093750f }, // 166 (1 0 13 2)
	{ 2.555556f, 7.222222f, 3.111111f, 0.113924f }, // 167 (1 0 14 1)
	{ 2.666667f, 6.666667f, 3.333333f, 0.150000f }, // 168 (1 0 15 0)
	{ 1.444444f, 14.111111f, 0.222222f, 0.049180f }, // 169 (1 1 0 14)
	{ 1.555556f, 13.555555f, 0.444444f, 0.047872f }, // 170 (1 1 1 13)
	{ 1.666667f, 13.000000f, 0.666667f, 0.047120f }, // 171 (1 1 2 12)
	{ 1.777778f, 12.444445f, 0.888889f, 0.046875f }, // 172 (1 1 3 11)
	{ 1.888889f, 11.888889f, 1.111111f, 0.047120f }, // 173 (1 1 4 10)
	{ 2.000000f, 11.333333f, 1.333333f, 0.047872f }, // 174 (1 1 5 9)
	{ 2.111111f, 10.777778f, 1.555556f, 0.049180f }, // 175 (1 1 6 8)
	{ 2.222222f, 10.222222f, 1.777778f, 0.051136f }, // 176 (1 1 7 7)
	{ 2.333333f, 9.666667f, 2.000000f, 0.053892f }, // 177 (1 1 8 6)
	{ 2.444444f, 9.111111f, 2.222222f, 0.057692f }, // 178 (1 1 9 5)
	{ 2.555556f, 8.555555f, 2.444444f, 0.062937f }, // 179 (1 1 10 4)
	{ 2.666667f, 8.000000f, 2.666667f, 0.070313f }, // 180 (1 1 11 3)
	{ 2.777778f, 7.444445f, 2.888889f, 0.081081f }, // 181 (1 1 12 2)
	{ 2.888889f, 6.888889f, 3.111111f, 0.097826f }, // 182 (1 1 13 1)
	{ 3.000000f, 6.333333f, 3.333333f, 0.126761f }, // 183 (1 1 14 0)
	{ 1.888889f, 13.222222f, 0.444444f, 0.040359f }, // 184 (1 2 0 13)
	{ 2.000000f, 12.666667f, 0.666667f, 0.040179f }, // 185 (1 2 1 12)
	{ 2.111111f, 12.111111f, 0.888889f, 0.040359f }, // 186 (1 2 2 11)
	{ 2.222222f, 11.555555f, 1.111111f, 0.040909f }, // 187 (1 2 3 10)
	{ 2.333333f, 11.000000f, 1.333333f, 0.041860f }, // 188 (1 2 4 9)
	{ 2.444444f, 10.444445f, 1.555556f, 0.043269f }, // 189 (1 2 5 8)
	{ 2.555556f, 9.888889f, 1.777778f, 0.045226f }, // 190 (1 2 6 7)
	{ 2.666667f, 9.333333f, 2.000000f, 0.047872f }, // 191 (1 2 7 6)
	{ 2.777778f, 8.777778f, 2.222222f, 0.051429f }, // 192 (1 2 8 5)
	{ 2.888889f, 8.222222f, 2.444444f, 0.056250f }, // 193 (1 2 9 4)
	{ 3.000000f, 7.666667f, 2.666667f, 0.062937f }, // 194 (1 2 10 3)
	{ 3.111111f, 7.111111f, 2.888889f, 0.072581f }, // 195 (1 2 11 2)
	{ 3.222222f, 6.555556f, 3.111111f, 0.087379f }, // 196 (1 2 12 1)
	{ 3.333333f, 6.000000f, 3.333333f, 0.112500f }, // 197 (1 2 13 0)
	{ 2.333333f, 12.333333f, 0.666667f, 0.035294f }, // 198 (1 3 0 12)
	{ 2.444444f, 11.777778f, 0.888889f, 0.035714f }, // 199 (1 3 1 11)
	{ 2.555556f, 11.222222f, 1.111111f, 0.036437f }, // 200 (1 3 2 10)
	{ 2.666667f, 10.666667f, 1.333333f, 0.037500f }, // 201 (1 3 3 9)
	{ 2.777778f, 10.111111f, 1.555556f, 0.038961f }, // 202 (1 3 4 8)
	{ 2.888889f, 9.555555f, 1.777778f, 0.040909f }, // 203 (1 3 5 7)
	{ 3.000000f, 9.000000f, 2.000000f, 0.043478f }, // 204 (1 3 6 6)
	{ 3.111111f, 8.444445f, 2.222222f, 0.046875f }, // 205 (1 3 7 5)
	{ 3.222222f, 7.888889f, 2.444444f, 0.051429f }, // 206 (1 3 8 4)
	{ 3.333333f, 7.333333f, 2.666667f, 0.057692f }, // 207 (1 3 9 3)
	{ 3.444444f, 6.777778f, 2.888889f, 0.066667f }, // 208 (1 3 10 2)
	{ 3.555556f, 6.222222f, 3.111111f, 0.080357f }, // 209 (1 3 11 1)
	{ 3.666667f, 5.666667f, 3.333333f, 0.103448f }, // 210 (1 3 12 0)
	{ 2.777778f, 11.444445f, 0.888889f, 0.032258f }, // 211 (1 4 0 11)
	{ 2.888889f, 10.888889f, 1.111111f, 0.033088f }, // 212 (1 4 1 10)
	{ 3.000000f, 10.333333f, 1.333333f, 0.034221f }, // 213 (1 4 2 9)
	{ 3.111111f, 9.777778f, 1.555556f, 0.035714f }, // 214 (1 4 3 8)
	{ 3.222222f, 9.222222f, 1.777778f, 0.037657f }, // 215 (1 4 4 7)
	{ 3.333333f, 8.666667f, 2.000000f, 0.040179f }, // 216 (1 4 5 6)
	{ 3.444444f, 8.111111f, 2.222222f, 0.043478f }, // 217 (1 4 6 5)
	{ 3.555556f, 7.555555f, 2.444444f, 0.047872f }, // 218 (1 4 7 4)
	{ 3.666667f, 7.000000f, 2.666667f, 0.053892f }, // 219 (1 4 8 3)
	{ 3.777778f, 6.444445f, 2.888889f, 0.062500f }, // 220 (1 4 9 2)
	{ 3.888889f, 5.888889f, 3.111111f, 0.075630f }, // 221 (1 4 10 1)
	{ 4.000000f, 5.333333f, 3.333333f, 0.097826f }, // 222 (1 4 11 0)
	{ 3.222222f, 10.555555f, 1.111111f, 0.030508f }, // 223 (1 5 0 10)
	{ 3.333333f, 10.000000f, 1.333333f, 0.031690f }, // 224 (1 5 1 9)
	{ 3.444444f, 9.444445f, 1.555556f, 0.033210f }, // 225 (1 5 2 8)
	{ 3.555556f, 8.888889f, 1.777778f, 0.035156f }, // 226 (1 5 3 7)
	{ 3.666667f, 8.333333f, 2.000000f, 0.037657f }, // 227 (1 5 4 6)
	{ 3.777778f, 7.777778f, 2.222222f, 0.040909f }, // 228 (1 5 5 5)
	{ 3.888889f, 7.222222f, 2.444444f, 0.045226f }, // 229 (1 5 6 4)
	{ 4.000000f, 6.666667f, 2.666667f, 0.051136f }, // 230 (1 5 7 3)
	{ 4.111111f, 6.111111f, 2.888889f, 0.059603f }, // 231 (1 5 8 2)
	{ 4.222222f, 5.555556f, 3.111111f, 0.072581f }, // 232 (1 5 9 1)
	{ 4.333333f, 5.000000f, 3.333333f, 0.094737f }, // 233 (1 5 10 0)
	{ 3.666667f, 9.666667f, 1.333333f, 0.029703f }, // 234 (1 6 0 9)
	{ 3.777778f, 9.111111f, 1.555556f, 0.031250f }, // 235 (1 6 1 8)
	{ 3.888889f, 8.555555f, 1.777778f, 0.033210f }, // 236 (1 6 2 7)
	{ 4.000000f, 8.000000f, 2.000000f, 0.035714f }, // 237 (1 6 3 6)
	{ 4.111111f, 7.444445f, 2.222222f, 0.038961f }, // 238 (1 6 4 5)
	{ 4.222222f, 6.888889f, 2.444444f, 0.043269f }, // 239 (1 6 5 4)
	{ 4.333333f, 6.333333f, 2.666667f, 0.049180f }, // 240 (1 6 6 3)
	{ 4.444445f, 5.777778f, 2.888889f, 0.057692f }, // 241 (1 6 7 2)
	{ 4.555555f, 5.222222f, 3.111111f, 0.070866f }, // 242 (1 6 8 1)
	{ 4.666667f, 4.666667f, 3.333333f, 0.093750f }, // 243 (1 6 9 0)
	{ 4.111111f, 8.777778f, 1.555556f, 0.029703f }, // 244 (1 7 0 8)
	{ 4.222222f, 8.222222f, 1.777778f, 0.031690f }, // 245 (1 7 1 7)
	{ 4.333333f, 7.666667f, 2.000000f, 0.034221f }, // 246 (1 7 2 6)
	{ 4.444445f, 7.111111f, 2.222222f, 0.037500f }, // 247 (1 7 3 5)
	{ 4.555555f, 6.555555f, 2.444444f, 0.041860f }, // 248 (1 7 4 4)
	{ 4.666667f, 6.000000f, 2.666667f, 0.047872f }, // 249 (1 7 5 3)
	{ 4.777778f, 5.444445f, 2.888889f, 0.056604f }, // 250 (1 7 6 2)
	{ 4.888889f, 4.888889f, 3.111111f, 0.070313f }, // 251 (1 7 7 1)
	{ 5.000000f, 4.333333f, 3.333333f, 0.094737f }, // 252 (1 7 8 0)
	{ 4.555555f, 7.888889f, 1.777778f, 0.030508f }, // 253 (1 8 0 7)
	{ 4.666667f, 7.333333f, 2.000000f, 0.033088f }, // 254 (1 8 1 6)
	{ 4.777778f, 6.777778f, 2.222222f, 0.036437f }, // 255 (1 8 2 5)
	{ 4.888889f, 6.222222f, 2.444444f, 0.040909f }, // 256 (1 8 3 4)
	{ 5.000000f, 5.666667f, 2.666667f, 0.047120f }, // 257 (1 8 4 3)
	{ 5.111111f, 5.111111f, 2.888889f, 0.056250f }, // 258 (1 8 5 2)
	{ 5.222222f, 4.555555f, 3.111111f, 0.070866f }, // 259 (1 8 6 1)
	{ 5.333333f, 4.000000f, 3.333333f, 0.097826f }, // 260 (1 8 7 0)
	{ 5.000000f, 7.000000f, 2.000000f, 0.032258f }, // 261 (1 9 0 6)
	{ 5.111111f, 6.444445f, 2.222222f, 0.035714f }, // 262 (1 9 1 5)
	{ 5.222222f, 5.888889f, 2.444444f, 0.040359f }, // 263 (1 9 2 4)
	{ 5.333333f, 5.333333f, 2.666667f, 0.046875f }, // 264 (1 9 3 3)
	{ 5.444445f, 4.777778f, 2.888889f, 0.056604f }, // 265 (1 9 4 2)
	{ 5.555556f, 4.222222f, 3.111111f, 0.072581f }, // 266 (1 9 5 1)
	{ 5.666667f, 3.666667f, 3.333333f, 0.103448f }, // 267 (1 9 6 0)
	{ 5.444445f, 6.111111f, 2.222222f, 0.035294f }, // 268 (1 10 0 5)
	{ 5.555556f, 5.555555f, 2.444444f, 0.040179f }, // 269 (1 10 1 4)
	{ 5.666667f, 5.000000f, 2.666667f, 0.047120f }, // 270 (1 10 2 3)
	{ 5.777778f, 4.444445f, 2.888889f, 0.057692f }, // 271 (1 10 3 2)
	{ 5.888889f, 3.888889f, 3.111111f, 0.075630f }, // 272 (1 10 4 1)
	{ 6.000000f, 3.333333f, 3.333333f, 0.112500f }, // 273 (1 10 5 0)
	{ 5.888889f, 5.222222f, 2.444444f, 0.040359f }, // 274 (1 11 0 4)
	{ 6.000000f, 4.666667f, 2.666667f, 0.047872f }, // 275 (1 11 1 3)
	{ 6.111111f, 4.111111f, 2.888889f, 0.059603f }, // 276 (1 11 2 2)
	{ 6.222222f, 3.555556f, 3.111111f, 0.080357f }, // 277 (1 11 3 1)
	{ 6.333333f, 3.000000f, 3.333333f, 0.126761f }, // 278 (1 11 4 0)
	{ 6.333333f, 4.333333f, 2.666667f, 0.049180f }, // 279 (1 12 0 3)
	{ 6.444445f, 3.777778f, 2.888889f, 0.062500f }, // 280 (1 12 1 2)
	{ 6.555556f, 3.222222f, 3.111111f, 0.087379f }, // 281 (1 12 2 1)
	{ 6.666667f, 2.666667f, 3.333333f, 0.150000f }, // 282 (1 12 3 0)
	{ 6.777778f, 3.444444f, 2.888889f, 0.066667f }, // 283 (1 13 0 2)
	{ 6.888889f, 2.888889f, 3.111111f, 0.097826f }, // 284 (1 13 1 1)
	{ 7.000000f, 2.333333f, 3.333333f, 0.191489f }, // 285 (1 13 2 0)
	{ 7.222222f, 2.555556f, 3.111111f, 0.113924f }, // 286 (1 14 0 1)
	{ 7.333333f, 2.000000f, 3.333333f, 0.281250f }, // 287 (1 14 1 0)
	{ 7.666667f, 1.666667f, 3.333333f, 0.600000f }, // 288 (1 15 0 0)
	{ 2.000000f, 14.000000f, 0.000000f, 0.035714f }, // 289 (2 0 0 14)
	{ 2.111111f, 13.444445f, 0.222222f, 0.035294f }, // 290 (2 0 1 13)
	{ 2.222222f, 12.888889f, 0.444444f, 0.035156f }, // 291 (2 0 2 12)
	{ 2.333333f, 12.333333f, 0.666667f, 0.035294f }, // 292 (2 0 3 11)
	{ 2.444444f, 11.777778f, 0.888889f, 0.035714f }, // 293 (2 0 4 10)
	{ 2.555556f, 11.222222f, 1.111111f, 0.036437f }, // 294 (2 0 5 9)
	{ 2.666667f, 10.666667f, 1.333333f, 0.037500f }, // 295 (2 0 6 8)
	{ 2.777778f, 10.111111f, 1.555556f, 0.038961f }, // 296 (2 0 7 7)
	{ 2.888889f, 9.555555f, 1.777778f, 0.040909f }, // 297 (2 0 8 6)
	{ 3.000000f, 9.000000f, 2.000000f, 0.043478f }, // 298 (2 0 9 5)
	{ 3.111111f, 8.444445f, 2.222222f, 0.046875f }, // 299 (2 0 10 4)
	{ 3.222222f, 7.888889f, 2.444444f, 0.051429f }, // 300 (2 0 11 3)
	{ 3.333333f, 7.333333f, 2.666667f, 0.057692f }, // 301 (2 0 12 2)
	{ 3.444444f, 6.777778f, 2.888889f, 0.066667f }, // 302 (2 0 13 1)
	{ 3.555556f, 6.222222f, 3.111111f, 0.080357f }, // 303 (2 0 14 0)
	{ 2.444444f, 13.111111f, 0.222222f, 0.031250f }, // 304 (2 1 0 13)
	{ 2.555556f, 12.555555f, 0.444444f, 0.031359f }, // 305 (2 1 1 12)
	{ 2.666667f, 12.000000f, 0.666667f, 0.031690f }, // 306 (2 1 2 11)
	{ 2.777778f, 11.444445f, 0.888889f, 0.032258f }, // 307 (2 1 3 10)
	{ 2.888889f, 10.888889f, 1.111111f, 0.033088f }, // 308 (2 1 4 9)
	{ 3.000000f, 10.333333f, 1.333333f, 0.034221f }, // 309 (2 1 5 8)
	{ 3.111111f, 9.777778f, 1.555556f, 0.035714f }, // 310 (2 1 6 7)
	{ 3.222222f, 9.222222f, 1.777778f, 0.037657f }, // 311 (2 1 7 6)
	{ 3.333333f, 8.666667f, 2.000000f, 0.040179f }, // 312 (2 1 8 5)
	{ 3.444444f, 8.111111f, 2.222222f, 0.043478f }, // 313 (2 1 9 4)
	{ 3.555556f, 7.555556f, 2.444444f, 0.047872f }, // 314 (2 1 10 3)
	{ 3.666667f, 7.000000f, 2.666667f, 0.053892f }, // 315 (2 1 11 2)
	{ 3.777778f, 6.444445f, 2.888889f, 0.062500f }, // 316 (2 1 12 1)
	{ 3.888889f, 5.888889f, 3.111111f, 0.075630f }, // 317 (2 1 13 0)
	{ 2.888889f, 12.222222f, 0.444444f, 0.028481f }, // 318 (2 2 0 12)
	{ 3.000000f, 11.666667f, 0.666667f, 0.028939f }, // 319 (2 2 1 11)
	{ 3.111111f, 11.111111f, 0.888889f, 0.029605f }, // 320 (2 2 2 10)
	{ 3.222222f, 10.555555f, 1.111111f, 0.030508f }, // 321 (2 2 3 9)
	{ 3.333333f, 10.000000f, 1.333333f, 0.031690f }, // 322 (2 2 4 8)
	{ 3.444444f, 9.444445f, 1.555556f, 0.033210f }, // 323 (2 2 5 7)
	{ 3.555556f, 8.888889f, 1.777778f, 0.035156f }, // 324 (2 2 6 6)
	{ 3.666667f, 8.333333f, 2.000000f, 0.037657f }, // 325 (2 2 7 5)
	{ 3.777778f, 7.777778f, 2.222222f, 0.040909f }, // 326 (2 2 8 4)
	{ 3.888889f, 7.222222f, 2.444444f, 0.045226f }, // 327 (2 2 9 3)
	{ 4.000000f, 6.666667f, 2.666667f, 0.051136f }, // 328 (2 2 10 2)
	{ 4.111111f, 6.111111f, 2.888889f, 0.059603f }, // 329 (2 2 11 1)
	{ 4.222222f, 5.555556f, 3.111111f, 0.072581f }, // 330 (2 2 12 0)
	{ 3.333333f, 11.333333f, 0.666667f, 0.026786f }, // 331 (2 3 0 11)
	{ 3.444444f, 10.777778f, 0.888889f, 0.027523f }, // 332 (2 3 1 10)
	{ 3.555556f, 10.222222f, 1.111111f, 0.028481f }, // 333 (2 3 2 9)
	{ 3.666667f, 9.666667f, 1.333333f, 0.029703f }, // 334 (2 3 3 8)
	{ 3.777778f, 9.111111f, 1.555556f, 0.031250f }, // 335 (2 3 4 7)
	{ 3.888889f, 8.555555f, 1.777778f, 0.033210f }, // 336 (2 3 5 6)
	{ 4.000000f, 8.000000f, 2.000000f, 0.035714f }, // 337 (2 3 6 5)
	{ 4.111111f, 7.444445f, 2.222222f, 0.038961f }, // 338 (2 3 7 4)
	{ 4.222222f, 6.888889f, 2.444444f, 0.043269f }, // 339 (2 3 8 3)
	{ 4.333333f, 6.333333f, 2.666667f, 0.049180f }, // 340 (2 3 9 2)
	{ 4.444445f, 5.777778f, 2.888889f, 0.057692f }, // 341 (2 3 10 1)
	{ 4.555555f, 5.222222f, 3.111111f, 0.070866f }, // 342 (2 3 11 0)
	{ 3.777778f, 10.444445f, 0.888889f, 0.025862f }, // 343 (2 4 0 10)
	{ 3.888889f, 9.888889f, 1.111111f, 0.026866f }, // 344 (2 4 1 9)
	{ 4.000000f, 9.333333f, 1.333333f, 0.028125f }, // 345 (2 4 2 8)
	{ 4.111111f, 8.777778f, 1.555556f, 0.029703f }, // 346 (2 4 3 7)
	{ 4.222222f, 8.222222f, 1.777778f, 0.031690f }, // 347 (2 4 4 6)
	{ 4.333333f, 7.666667f, 2.000000f, 0.034221f }, // 348 (2 4 5 5)
	{ 4.444445f, 7.111111f, 2.222222f, 0.037500f }, // 349 (2 4 6 4)
	{ 4.555555f, 6.555555f, 2.444444f, 0.041860f }, // 350 (2 4 7 3)
	{ 4.666667f, 6.000000f, 2.666667f, 0.047872f }, // 351 (2 4 8 2)
	{ 4.777778f, 5.444445f, 2.888889f, 0.056604f }, // 352 (2 4 9 1)
	{ 4.888889f, 4.888889f, 3.111111f, 0.070313f }, // 353 (2 4 10 0)
	{ 4.222222f, 9.555555f, 1.111111f, 0.025568f }, // 354 (2 5 0 9)
	{ 4.333333f, 9.000000f, 1.333333f, 0.026866f }, // 355 (2 5 1 8)
	{ 4.444445f, 8.444445f, 1.555556f, 0.028481f }, // 356 (2 5 2 7)
	{ 4.555555f, 7.888889f, 1.777778f, 0.030508f }, // 357 (2 5 3 6)
	{ 4.666667f, 7.333333f, 2.000000f, 0.033088f }, // 358 (2 5 4 5)
	{ 4.777778f, 6.777778f, 2.222222f, 0.036437f }, // 359 (2 5 5 4)
	{ 4.888889f, 6.222222f, 2.444444f, 0.040909f }, // 360 (2 5 6 3)
	{ 5.000000f, 5.666667f, 2.666667f, 0.047120f }, // 361 (2 5 7 2)
	{ 5.111111f, 5.111111f, 2.888889f, 0.056250f }, // 362 (2 5 8 1)
	{ 5.222222f, 4.555556f, 3.111111f, 0.070866f }, // 363 (2 5 9 0)
	{ 4.666667f, 8.666667f, 1.333333f, 0.025862f }, // 364 (2 6 0 8)
	{ 4.777778f, 8.111111f, 1.555556f, 0.027523f }, // 365 (2 6 1 7)
	{ 4.888889f, 7.555555f, 1.777778f, 0.029605f }, // 366 (2 6 2 6)
	{ 5.000000f, 7.000000f, 2.000000f, 0.032258f }, // 367 (2 6 3 5)
	{ 5.111111f, 6.444445f, 2.222222f, 0.035714f }, // 368 (2 6 4 4)
	{ 5.222222f, 5.888889f, 2.444444f, 0.040359f }, // 369 (2 6 5 3)
	{ 5.333333f, 5.333333f, 2.666667f, 0.046875f }, // 370 (2 6 6 2)
	{ 5.444445f, 4.777778f, 2.888889f, 0.056604f }, // 371 (2 6 7 1)
	{ 5.555555f, 4.222222f, 3.111111f, 0.072581f }, // 372 (2 6 8 0)
	{ 5.111111f, 7.777778f, 1.555556f, 0.026786f }, // 373 (2 7 0 7)
	{ 5.222222f, 7.222222f, 1.777778f, 0.028939f }, // 374 (2 7 1 6)
	{ 5.333333f, 6.666667f, 2.000000f, 0.031690f }, // 375 (2 7 2 5)
	{ 5.444445f, 6.111111f, 2.222222f, 0.035294f }, // 376 (2 7 3 4)
	{ 5.555555f, 5.555555f, 2.444444f, 0.040179f }, // 377 (2 7 4 3)
	{ 5.666667f, 5.000000f, 2.666667f, 0.047120f }, // 378 (2 7 5 2)
	{ 5.777778f, 4.444445f, 2.888889f, 0.057692f }, // 379 (2 7 6 1)
	{ 5.888889f, 3.888889f, 3.111111f, 0.075630f }, // 380 (2 7 7 0)
	{ 5.555555f, 6.888889f, 1.777778f, 0.028481f }, // 381 (2 8 0 6)
	{ 5.666667f, 6.333333f, 2.000000f, 0.031359f }, // 382 (2 8 1 5)
	{ 5.777778f, 5.777778f, 2.222222f, 0.035156f }, // 383 (2 8 2 4)
	{ 5.888889f, 5.222222f, 2.444444f, 0.040359f }, // 384 (2 8 3 3)
	{ 6.000000f, 4.666667f, 2.666667f, 0.047872f }, // 385 (2 8 4 2)
	{ 6.111111f, 4.111111f, 2.888889f, 0.059603f }, // 386 (2 8 5 1)
	{ 6.222222f, 3.555556f, 3.111111f, 0.080357f }, // 387 (2 8 6 0)
	{ 6.000000f, 6.000000f, 2.000000f, 0.031250f }, // 388 (2 9 0 5)
	{ 6.111111f, 5.444445f, 2.222222f, 0.035294f }, // 389 (2 9 1 4)
	{ 6.222222f, 4.888889f, 2.444444f, 0.040909f }, // 390 (2 9 2 3)
	{ 6.333333f, 4.333333f, 2.666667f, 0.049180f }, // 391 (2 9 3 2)
	{ 6.444445f, 3.777778f, 2.888889f, 0.062500f }, // 392 (2 9 4 1)
	{ 6.555556f, 3.222222f, 3.111111f, 0.087379f }, // 393 (2 9 5 0)
	{ 6.444445f, 5.111111f, 2.222222f, 0.035714f }, // 394 (2 10 0 4)
	{ 6.555556f, 4.555555f, 2.444444f, 0.041860f }, // 395 (2 10 1 3)
	{ 6.666667f, 4.000000f, 2.666667f, 0.051136f }, // 396 (2 10 2 2)
	{ 6.777778f, 3.444444f, 2.888889f, 0.066667f }, // 397 (2 10 3 1)
	{ 6.888889f, 2.888889f, 3.111111f, 0.097826f }, // 398 (2 10 4 0)
	{ 6.888889f, 4.222222f, 2.444444f, 0.043269f }, // 399 (2 11 0 3)
	{ 7.000000f, 3.666667f, 2.666667f, 0.053892f }, // 400 (2 11 1 2)
	{ 7.111111f, 3.111111f, 2.888889f, 0.072581f }, // 401 (2 11 2 1)
	{ 7.222222f, 2.555556f, 3.111111f, 0.113924f }, // 402 (2 11 3 0)
	{ 7.333333f, 3.333333f, 2.666667f, 0.057692f }, // 403 (2 12 0 2)
	{ 7.444445f, 2.777778f, 2.888889f, 0.081081f }, // 404 (2 12 1 1)
	{ 7.555556f, 2.222222f, 3.111111f, 0.140625f }, // 405 (2 12 2 0)
	{ 7.777778f, 2.444444f, 2.888889f, 0.093750f }, // 406 (2 13 0 1)
	{ 7.888889f, 1.888889f, 3.111111f, 0.191489f }, // 407 (2 13 1 0)
	{ 8.222222f, 1.555556f, 3.111111f, 0.321429f }, // 408 (2 14 0 0)
	{ 3.000000f, 13.000000f, 0.000000f, 0.025641f }, // 409 (3 0 0 13)
	{ 3.111111f, 12.444445f, 0.222222f, 0.025862f }, // 410 (3 0 1 12)
	{ 3.222222f, 11.888889f, 0.444444f, 0.026239f }, // 411 (3 0 2 11)
	{ 3.333333f, 11.333333f, 0.666667f, 0.026786f }, // 412 (3 0 3 10)
	{ 3.444444f, 10.777778f, 0.888889f, 0.027523f }, // 413 (3 0 4 9)
	{ 3.555556f, 10.222222f, 1.111111f, 0.028481f }, // 414 (3 0 5 8)
	{ 3.666667f, 9.666667f, 1.333333f, 0.029703f }, // 415 (3 0 6 7)
	{ 3.777778f, 9.111111f, 1.555556f, 0.031250f }, // 416 (3 0 7 6)
	{ 3.888889f, 8.555555f, 1.777778f, 0.033210f }, // 417 (3 0 8 5)
	{ 4.000000f, 8.000000f, 2.000000f, 0.035714f }, // 418 (3 0 9 4)
	{ 4.111111f, 7.444445f, 2.222222f, 0.038961f }, // 419 (3 0 10 3)
	{ 4.222222f, 6.888889f, 2.444444f, 0.043269f }, // 420 (3 0 11 2)
	{ 4.333333f, 6.333333f, 2.666667f, 0.049180f }, // 421 (3 0 12 1)
	{ 4.444445f, 5.777778f, 2.888889f, 0.057692f }, // 422 (3 0 13 0)
	{ 3.444444f, 12.111111f, 0.222222f, 0.024000f }, // 423 (3 1 0 12)
	{ 3.555556f, 11.555555f, 0.444444f, 0.024457f }, // 424 (3 1 1 11)
	{ 3.666667f, 11.000000f, 0.666667f, 0.025070f }, // 425 (3 1 2 10)
	{ 3.777778f, 10.444445f, 0.888889f, 0.025862f }, // 426 (3 1 3 9)
	{ 3.888889f, 9.888889f, 1.111111f, 0.026866f }, // 427 (3 1 4 8)
	{ 4.000000f, 9.333333f, 1.333333f, 0.028125f }, // 428 (3 1 5 7)
	{ 4.111111f, 8.777778f, 1.555556f, 0.029703f }, // 429 (3 1 6 6)
	{ 4.222222f, 8.222222f, 1.777778f, 0.031690f }, // 430 (3 1 7 5)
	{ 4.333333f, 7.666667f, 2.000000f, 0.034221f }, // 431 (3 1 8 4)
	{ 4.444445f, 7.111111f, 2.222222f, 0.037500f }, // 432 (3 1 9 3)
	{ 4.555555f, 6.555556f, 2.444444f, 0.041860f }, // 433 (3 1 10 2)
	{ 4.666667f, 6.000000f, 2.666667f, 0.047872f }, // 434 (3 1 11 1)
	{ 4.777778f, 5.444445f, 2.888889f, 0.056604f }, // 435 (3 1 12 0)
	{ 3.888889f, 11.222222f, 0.444444f, 0.023018f }, // 436 (3 2 0 11)
	{ 4.000000f, 10.666667f, 0.666667f, 0.023684f }, // 437 (3 2 1 10)
	{ 4.111111f, 10.111111f, 0.888889f, 0.024523f }, // 438 (3 2 2 9)
	{ 4.222222f, 9.555555f, 1.111111f, 0.025568f }, // 439 (3 2 3 8)
	{ 4.333333f, 9.000000f, 1.333333f, 0.026866f }, // 440 (3 2 4 7)
	{ 4.444445f, 8.444445f, 1.555556f, 0.028481f }, // 441 (3 2 5 6)
	{ 4.555555f, 7.888889f, 1.777778f, 0.030508f }, // 442 (3 2 6 5)
	{ 4.666667f, 7.333333f, 2.000000f, 0.033088f }, // 443 (3 2 7 4)
	{ 4.777778f, 6.777778f, 2.222222f, 0.036437f }, // 444 (3 2 8 3)
	{ 4.888889f, 6.222222f, 2.444444f, 0.040909f }, // 445 (3 2 9 2)
	{ 5.000000f, 5.666667f, 2.666667f, 0.047120f }, // 446 (3 2 10 1)
	{ 5.111111f, 5.111111f, 2.888889f, 0.056250f }, // 447 (3 2 11 0)
	{ 4.333333f, 10.333333f, 0.666667f, 0.022556f }, // 448 (3 3 0 10)
	{ 4.444445f, 9.777778f, 0.888889f, 0.023438f }, // 449 (3 3 1 9)
	{ 4.555555f, 9.222222f, 1.111111f, 0.024523f }, // 450 (3 3 2 8)
	{ 4.666667f, 8.666667f, 1.333333f, 0.025862f }, // 451 (3 3 3 7)
	{ 4.777778f, 8.111111f, 1.555556f, 0.027523f }, // 452 (3 3 4 6)
	{ 4.888889f, 7.555555f, 1.777778f, 0.029605f }, // 453 (3 3 5 5)
	{ 5.000000f, 7.000000f, 2.000000f, 0.032258f }, // 454 (3 3 6 4)
	{ 5.111111f, 6.444445f, 2.222222f, 0.035714f }, // 455 (3 3 7 3)
	{ 5.222222f, 5.888889f, 2.444444f, 0.040359f }, // 456 (3 3 8 2)
	{ 5.333333f, 5.333333f, 2.666667f, 0.046875f }, // 457 (3 3 9 1)
	{ 5.444445f, 4.777778f, 2.888889f, 0.056604f }, // 458 (3 3 10 0)
	{ 4.777778f, 9.444445f, 0.888889f, 0.022556f }, // 459 (3 4 0 9)
	{ 4.888889f, 8.888889f, 1.111111f, 0.023684f }, // 460 (3 4 1 8)
	{ 5.000000f, 8.333333f, 1.333333f, 0.025070f }, // 461 (3 4 2 7)
	{ 5.111111f, 7.777778f, 1.555556f, 0.026786f }, // 462 (3 4 3 6)
	{ 5.222222f, 7.222222f, 1.777778f, 0.028939f }, // 463 (3 4 4 5)
	{ 5.333333f, 6.666667f, 2.000000f, 0.031690f }, // 464 (3 4 5 4)
	{ 5.444445f, 6.111111f, 2.222222f, 0.035294f }, // 465 (3 4 6 3)
	{ 5.555555f, 5.555555f, 2.444444f, 0.040179f }, // 466 (3 4 7 2)
	{ 5.666667f, 5.000000f, 2.666667f, 0.047120f }, // 467 (3 4 8 1)
	{ 5.777778f, 4.444445f, 2.888889f, 0.057692f }, // 468 (3 4 9 0)
	{ 5.222222f, 8.555555f, 1.111111f, 0.023018f }, // 469 (3 5 0 8)
	{ 5.333333f, 8.000000f, 1.333333f, 0.024457f }, // 470 (3 5 1 7)
	{ 5.444445f, 7.444445f, 1.555556f, 0.026239f }, // 471 (3 5 2 6)
	{ 5.555555f, 6.888889f, 1.777778f, 0.028481f }, // 472 (3 5 3 5)
	{ 5.666667f, 6.333333f, 2.000000f, 0.031359f }, // 473 (3 5 4 4)
	{ 5.777778f, 5.777778f, 2.222222f, 0.035156f }, // 474 (3 5 5 3)
	{ 5.888889f, 5.222222f, 2.444444f, 0.040359f }, // 475 (3 5 6 2)
	{ 6.000000f, 4.666667f, 2.666667f, 0.047872f }, // 476 (3 5 7 1)
	{ 6.111111f, 4.111111f, 2.888889f, 0.059603f }, // 477 (3 5 8 0)
	{ 5.666667f, 7.666667f, 1.333333f, 0.024000f }, // 478 (3 6 0 7)
	{ 5.777778f, 7.111111f, 1.555556f, 0.025862f }, // 479 (3 6 1 6)
	{ 5.888889f, 6.555555f, 1.777778f, 0.028213f }, // 480 (3 6 2 5)
	{ 6.000000f, 6.000000f, 2.000000f, 0.031250f }, // 481 (3 6 3 4)
	{ 6.111111f, 5.444445f, 2.222222f, 0.035294f }, // 482 (3 6 4 3)
	{ 6.222222f, 4.888889f, 2.444444f, 0.040909f }, // 483 (3 6 5 2)
	{ 6.333333f, 4.333333f, 2.666667f, 0.049180f }, // 484 (3 6 6 1)
	{ 6.444445f, 3.777778f, 2.888889f, 0.062500f }, // 485 (3 6 7 0)
	{ 6.111111f, 6.777778f, 1.555556f, 0.025641f }, // 486 (3 7 0 6)
	{ 6.222222f, 6.222222f, 1.777778f, 0.028125f }, // 487 (3 7 1 5)
	{ 6.333333f, 5.666667f, 2.000000f, 0.031359f }, // 488 (3 7 2 4)
	{ 6.444445f, 5.111111f, 2.222222f, 0.035714f }, // 489 (3 7 3 3)
	{ 6.555555f, 4.555555f, 2.444444f, 0.041860f }, // 490 (3 7 4 2)
	{ 6.666667f, 4.000000f, 2.666667f, 0.051136f }, // 491 (3 7 5 1)
	{ 6.777778f, 3.444444f, 2.888889f, 0.066667f }, // 492 (3 7 6 0)
	{ 6.555555f, 5.888889f, 1.777778f, 0.028213f }, // 493 (3 8 0 5)
	{ 6.666667f, 5.333333f, 2.000000f, 0.031690f }, // 494 (3 8 1 4)
	{ 6.777778f, 4.777778f, 2.222222f, 0.036437f }, // 495 (3 8 2 3)
	{ 6.888889f, 4.222222f, 2.444444f, 0.043269f }, // 496 (3 8 3 2)
	{ 7.000000f, 3.666667f, 2.666667f, 0.053892f }, // 497 (3 8 4 1)
	{ 7.111111f, 3.111111f, 2.888889f, 0.072581f }, // 498 (3 8 5 0)
	{ 7.000000f, 5.000000f, 2.000000f, 0.032258f }, // 499 (3 9 0 4)
	{ 7.111111f, 4.444445f, 2.222222f, 0.037500f }, // 500 (3 9 1 3)
	{ 7.222222f, 3.888889f, 2.444444f, 0.045226f }, // 501 (3 9 2 2)
	{ 7.333333f, 3.333333f, 2.666667f, 0.057692f }, // 502 (3 9 3 1)
	{ 7.444445f, 2.777778f, 2.888889f, 0.081081f }, // 503 (3 9 4 0)
	{ 7.444445f, 4.111111f, 2.222222f, 0.038961f }, // 504 (3 10 0 3)
	{ 7.555556f, 3.555556f, 2.444444f, 0.047872f }, // 505 (3 10 1 2)
	{ 7.666667f, 3.000000f, 2.666667f, 0.062937f }, // 506 (3 10 2 1)
	{ 7.777778f, 2.444444f, 2.888889f, 0.093750f }, // 507 (3 10 3 0)
	{ 7.888889f, 3.222222f, 2.444444f, 0.051429f }, // 508 (3 11 0 2)
	{ 8.000000f, 2.666667f, 2.666667f, 0.070313f }, // 509 (3 11 1 1)
	{ 8.111111f, 2.111111f, 2.888889f, 0.113924f }, // 510 (3 11 2 0)
	{ 8.333333f, 2.333333f, 2.666667f, 0.081081f }, // 511 (3 12 0 1)
	{ 8.444445f, 1.777778f, 2.888889f, 0.150000f }, // 512 (3 12 1 0)
	{ 8.777778f, 1.444444f, 2.888889f, 0.230769f }, // 513 (3 13 0 0)
	{ 4.000000f, 12.000000f, 0.000000f, 0.020833f }, // 514 (4 0 0 12)
	{ 4.111111f, 11.444445f, 0.222222f, 0.021277f }, // 515 (4 0 1 11)
	{ 4.222222f, 10.888889f, 0.444444f, 0.021845f }, // 516 (4 0 2 10)
	{ 4.333333f, 10.333333f, 0.666667f, 0.022556f }, // 517 (4 0 3 9)
	{ 4.444445f, 9.777778f, 0.888889f, 0.023438f }, // 518 (4 0 4 8)
	{ 4.555555f, 9.222222f, 1.111111f, 0.024523f }, // 519 (4 0 5 7)
	{ 4.666667f, 8.666667f, 1.333333f, 0.025862f }, // 520 (4 0 6 6)
	{ 4.777778f, 8.111111f, 1.555556f, 0.027523f }, // 521 (4 0 7 5)
	{ 4.888889f, 7.555555f, 1.777778f, 0.029605f }, // 522 (4 0 8 4)
	{ 5.000000f, 7.000000f, 2.000000f, 0.032258f }, // 523 (4 0 9 3)
	{ 5.111111f, 6.444445f, 2.222222f, 0.035714f }, // 524 (4 0 10 2)
	{ 5.222222f, 5.888889f, 2.444444f, 0.040359f }, // 525 (4 0 11 1)
	{ 5.333333f, 5.333333f, 2.666667f, 0.046875f }, // 526 (4 0 12 0)
	{ 4.444445f, 11.111111f, 0.222222f, 0.020270f }, // 527 (4 1 0 11)
	{ 4.555555f, 10.555555f, 0.444444f, 0.020882f }, // 528 (4 1 1 10)
	{ 4.666667f, 10.000000f, 0.666667f, 0.021635f }, // 529 (4 1 2 9)
	{ 4.777778f, 9.444445f, 0.888889f, 0.022556f }, // 530 (4 1 3 8)
	{ 4.888889f, 8.888889f, 1.111111f, 0.023684f }, // 531 (4 1 4 7)
	{ 5.000000f, 8.333333f, 1.333333f, 0.025070f }, // 532 (4 1 5 6)
	{ 5.111111f, 7.777778f, 1.555556f, 0.026786f }, // 533 (4 1 6 5)
	{ 5.222222f, 7.222222f, 1.777778f, 0.028939f }, // 534 (4 1 7 4)
	{ 5.333333f, 6.666667f, 2.000000f, 0.031690f }, // 535 (4 1 8 3)
	{ 5.444445f, 6.111111f, 2.222222f, 0.035294f }, // 536 (4 1 9 2)
	{ 5.555555f, 5.555556f, 2.444444f, 0.040179f }, // 537 (4 1 10 1)
	{ 5.666667f, 5.000000f, 2.666667f, 0.047120f }, // 538 (4 1 11 0)
	{ 4.888889f, 10.222222f, 0.444444f, 0.020089f }, // 539 (4 2 0 10)
	{ 5.000000f, 9.666667f, 0.666667f, 0.020882f }, // 540 (4 2 1 9)
	{ 5.111111f, 9.111111f, 0.888889f, 0.021845f }, // 541 (4 2 2 8)
	{ 5.222222f, 8.555555f, 1.111111f, 0.023018f }, // 542 (4 2 3 7)
	{ 5.333333f, 8.000000f, 1.333333f, 0.024457f }, // 543 (4 2 4 6)
	{ 5.444445f, 7.444445f, 1.555556f, 0.026239f }, // 544 (4 2 5 5)
	{ 5.555555f, 6.888889f, 1.777778f, 0.028481f }, // 545 (4 2 6 4)
	{ 5.666667f, 6.333333f, 2.000000f, 0.031359f }, // 546 (4 2 7 3)
	{ 5.777778f, 5.777778f, 2.222222f, 0.035156f }, // 547 (4 2 8 2)
	{ 5.888889f, 5.222222f, 2.444444f, 0.040359f }, // 548 (4 2 9 1)
	{ 6.000000f, 4.666667f, 2.666667f, 0.047872f }, // 549 (4 2 10 0)
	{ 5.333333f, 9.333333f, 0.666667f, 0.020270f }, // 550 (4 3 0 9)
	{ 5.444445f, 8.777778f, 0.888889f, 0.021277f }, // 551 (4 3 1 8)
	{ 5.555555f, 8.222222f, 1.111111f, 0.022500f }, // 552 (4 3 2 7)
	{ 5.666667f, 7.666667f, 1.333333f, 0.024000f }, // 553 (4 3 3 6)
	{ 5.777778f, 7.111111f, 1.555556f, 0.025862f }, // 554 (4 3 4 5)
	{ 5.888889f, 6.555555f, 1.777778f, 0.028213f }, // 555 (4 3 5 4)
	{ 6.000000f, 6.000000f, 2.000000f, 0.031250f }, // 556 (4 3 6 3)
	{ 6.111111f, 5.444445f, 2.222222f, 0.035294f }, // 557 (4 3 7 2)
	{ 6.222222f, 4.888889f, 2.444444f, 0.040909f }, // 558 (4 3 8 1)
	{ 6.333333f, 4.333333f, 2.666667f, 0.049180f }, // 559 (4 3 9 0)
	{ 5.777778f, 8.444445f, 0.888889f, 0.020833f }, // 560 (4 4 0 8)
	{ 5.888889f, 7.888889f, 1.111111f, 0.022113f }, // 561 (4 4 1 7)
	{ 6.000000f, 7.333333f, 1.333333f, 0.023684f }, // 562 (4 4 2 6)
	{ 6.111111f, 6.777778f, 1.555556f, 0.025641f }, // 563 (4 4 3 5)
	{ 6.222222f, 6.222222f, 1.777778f, 0.028125f }, // 564 (4 4 4 4)
	{ 6.333333f, 5.666667f, 2.000000f, 0.031359f }, // 565 (4 4 5 3)
	{ 6.444445f, 5.111111f, 2.222222f, 0.035714f }, // 566 (4 4 6 2)
	{ 6.555555f, 4.555555f, 2.444444f, 0.041860f }, // 567 (4 4 7 1)
	{ 6.666667f, 4.000000f, 2.666667f, 0.051136f }, // 568 (4 4 8 0)
	{ 6.222222f, 7.555555f, 1.111111f, 0.021845f }, // 569 (4 5 0 7)
	{ 6.333333f, 7.000000f, 1.333333f, 0.023499f }, // 570 (4 5 1 6)
	{ 6.444445f, 6.444445f, 1.555556f, 0.025568f }, // 571 (4 5 2 5)
	{ 6.555555f, 5.888889f, 1.777778f, 0.028213f }, // 572 (4 5 3 4)
	{ 6.666667f, 5.333333f, 2.000000f, 0.031690f }, // 573 (4 5 4 3)
	{ 6.777778f, 4.777778f, 2.222222f, 0.036437f }, // 574 (4 5 5 2)
	{ 6.888889f, 4.222222f, 2.444444f, 0.043269f }, // 575 (4 5 6 1)
	{ 7.000000f, 3.666667f, 2.666667f, 0.053892f }, // 576 (4 5 7 0)
	{ 6.666667f, 6.666667f, 1.333333f, 0.023438f }, // 577 (4 6 0 6)
	{ 6.777778f, 6.111111f, 1.555556f, 0.025641f }, // 578 (4 6 1 5)
	{ 6.888889f, 5.555555f, 1.777778f, 0.028481f }, // 579 (4 6 2 4)
	{ 7.000000f, 5.000000f, 2.000000f, 0.032258f }, // 580 (4 6 3 3)
	{ 7.111111f, 4.444445f, 2.222222f, 0.037500f }, // 581 (4 6 4 2)
	{ 7.222222f, 3.888889f, 2.444444f, 0.045226f }, // 582 (4 6 5 1)
	{ 7.333333f, 3.333333f, 2.666667f, 0.057692f }, // 583 (4 6 6 0)
	{ 7.111111f, 5.777778f, 1.555556f, 0.025862f }, // 584 (4 7 0 5)
	{ 7.222222f, 5.222222f, 1.777778f, 0.028939f }, // 585 (4 7 1 4)
	{ 7.333333f, 4.666667f, 2.000000f, 0.033088f }, // 586 (4 7 2 3)
	{ 7.444445f, 4.111111f, 2.222222f, 0.038961f }, // 587 (4 7 3 2)
	{ 7.555555f, 3.555556f, 2.444444f, 0.047872f }, // 588 (4 7 4 1)
	{ 7.666667f, 3.000000f, 2.666667f, 0.062937f }, // 589 (4 7 5 0)
	{ 7.555555f, 4.888889f, 1.777778f, 0.029605f }, // 590 (4 8 0 4)
	{ 7.666667f, 4.333333f, 2.000000f, 0.034221f }, // 591 (4 8 1 3)
	{ 7.777778f, 3.777778f, 2.222222f, 0.040909f }, // 592 (4 8 2 2)
	{ 7.888889f, 3.222222f, 2.444444f, 0.051429f }, // 593 (4 8 3 1)
	{ 8.000000f, 2.666667f, 2.666667f, 0.070313f }, // 594 (4 8 4 0)
	{ 8.000000f, 4.000000f, 2.000000f, 0.035714f }, // 595 (4 9 0 3)
	{ 8.111111f, 3.444444f, 2.222222f, 0.043478f }, // 596 (4 9 1 2)
	{ 8.222222f, 2.888889f, 2.444444f, 0.056250f }, // 597 (4 9 2 1)
	{ 8.333333f, 2.333333f, 2.666667f, 0.081081f }, // 598 (4 9 3 0)
	{ 8.444445f, 3.111111f, 2.222222f, 0.046875f }, // 599 (4 10 0 2)
	{ 8.555555f, 2.555556f, 2.444444f, 0.062937f }, // 600 (4 10 1 1)
	{ 8.666667f, 2.000000f, 2.666667f, 0.097826f }, // 601 (4 10 2 0)
	{ 8.888889f, 2.222222f, 2.444444f, 0.072581f }, // 602 (4 11 0 1)
	{ 9.000000f, 1.666667f, 2.666667f, 0.126761f }, // 603 (4 11 1 0)
	{ 9.333333f, 1.333333f, 2.666667f, 0.187500f }, // 604 (4 12 0 0)
	{ 5.000000f, 11.000000f, 0.000000f, 0.018182f }, // 605 (5 0 0 11)
	{ 5.111111f, 10.444445f, 0.222222f, 0.018750f }, // 606 (5 0 1 10)
	{ 5.222222f, 9.888889f, 0.444444f, 0.019438f }, // 607 (5 0 2 9)
	{ 5.333333f, 9.333333f, 0.666667f, 0.020270f }, // 608 (5 0 3 8)
	{ 5.444445f, 8.777778f, 0.888889f, 0.021277f }, // 609 (5 0 4 7)
	{ 5.555555f, 8.222222f, 1.111111f, 0.022500f }, // 610 (5 0 5 6)
	{ 5.666667f, 7.666667f, 1.333333f, 0.024000f }, // 611 (5 0 6 5)
	{ 5.777778f, 7.111111f, 1.555556f, 0.025862f }, // 612 (5 0 7 4)
	{ 5.888889f, 6.555555f, 1.777778f, 0.028213f }, // 613 (5 0 8 3)
	{ 6.000000f, 6.000000f, 2.000000f, 0.031250f }, // 614 (5 0 9 2)
	{ 6.111111f, 5.444445f, 2.222222f, 0.035294f }, // 615 (5 0 10 1)
	{ 6.222222f, 4.888889f, 2.444444f, 0.040909f }, // 616 (5 0 11 0)
	{ 5.444445f, 10.111111f, 0.222222f, 0.018182f }, // 617 (5 1 0 10)
	{ 5.555555f, 9.555555f, 0.444444f, 0.018908f }, // 618 (5 1 1 9)
	{ 5.666667f, 9.000000f, 0.666667f, 0.019780f }, // 619 (5 1 2 8)
	{ 5.777778f, 8.444445f, 0.888889f, 0.020833f }, // 620 (5 1 3 7)
	{ 5.888889f, 7.888889f, 1.111111f, 0.022113f }, // 621 (5 1 4 6)
	{ 6.000000f, 7.333333f, 1.333333f, 0.023684f }, // 622 (5 1 5 5)
	{ 6.111111f, 6.777778f, 1.555556f, 0.025641f }, // 623 (5 1 6 4)
	{ 6.222222f, 6.222222f, 1.777778f, 0.028125f }, // 624 (5 1 7 3)
	{ 6.333333f, 5.666667f, 2.000000f, 0.031359f }, // 625 (5 1 8 2)
	{ 6.444445f, 5.111111f, 2.222222f, 0.035714f }, // 626 (5 1 9 1)
	{ 6.555555f, 4.555556f, 2.444444f, 0.041860f }, // 627 (5 1 10 0)
	{ 5.888889f, 9.222222f, 0.444444f, 0.018480f }, // 628 (5 2 0 9)
	{ 6.000000f, 8.666667f, 0.666667f, 0.019397f }, // 629 (5 2 1 8)
	{ 6.111111f, 8.111111f, 0.888889f, 0.020501f }, // 630 (5 2 2 7)
	{ 6.222222f, 7.555555f, 1.111111f, 0.021845f }, // 631 (5 2 3 6)
	{ 6.333333f, 7.000000f, 1.333333f, 0.023499f }, // 632 (5 2 4 5)
	{ 6.444445f, 6.444445f, 1.555556f, 0.025568f }, // 633 (5 2 5 4)
	{ 6.555555f, 5.888889f, 1.777778f, 0.028213f }, // 634 (5 2 6 3)
	{ 6.666667f, 5.333333f, 2.000000f, 0.031690f }, // 635 (5 2 7 2)
	{ 6.777778f, 4.777778f, 2.222222f, 0.036437f }, // 636 (5 2 8 1)
	{ 6.888889f, 4.222222f, 2.444444f, 0.043269f }, // 637 (5 2 9 0)
	{ 6.333333f, 8.333333f, 0.666667f, 0.019108f }, // 638 (5 3 0 8)
	{ 6.444445f, 7.777778f, 0.888889f, 0.020270f }, // 639 (5 3 1 7)
	{ 6.555555f, 7.222222f, 1.111111f, 0.021687f }, // 640 (5 3 2 6)
	{ 6.666667f, 6.666667f, 1.333333f, 0.023438f }, // 641 (5 3 3 5)
	{ 6.777778f, 6.111111f, 1.555556f, 0.025641f }, // 642 (5 3 4 4)
	{ 6.888889f, 5.555555f, 1.777778f, 0.028481f }, // 643 (5 3 5 3)
	{ 7.000000f, 5.000000f, 2.000000f, 0.032258f }, // 644 (5 3 6 2)
	{ 7.111111f, 4.444445f, 2.222222f, 0.037500f }, // 645 (5 3 7 1)
	{ 7.222222f, 3.888889f, 2.444444f, 0.045226f }, // 646 (5 3 8 0)
	{ 6.777778f, 7.444445f, 0.888889f, 0.020134f }, // 647 (5 4 0 7)
	{ 6.888889f, 6.888889f, 1.111111f, 0.021635f }, // 648 (5 4 1 6)
	{ 7.000000f, 6.333333f, 1.333333f, 0.023499f }, // 649 (5 4 2 5)
	{ 7.111111f, 5.777778f, 1.555556f, 0.025862f }, // 650 (5 4 3 4)
	{ 7.222222f, 5.222222f, 1.777778f, 0.028939f }, // 651 (5 4 4 3)
	{ 7.333333f, 4.666667f, 2.000000f, 0.033088f }, // 652 (5 4 5 2)
	{ 7.444445f, 4.111111f, 2.222222f, 0.038961f }, // 653 (5 4 6 1)
	{ 7.555555f, 3.555556f, 2.444444f, 0.047872f }, // 654 (5 4 7 0)
	{ 7.222222f, 6.555555f, 1.111111f, 0.021687f }, // 655 (5 5 0 6)
	{ 7.333333f, 6.000000f, 1.333333f, 0.023684f }, // 656 (5 5 1 5)
	{ 7.444445f, 5.444445f, 1.555556f, 0.026239f }, // 657 (5 5 2 4)
	{ 7.555555f, 4.888889f, 1.777778f, 0.029605f }, // 658 (5 5 3 3)
	{ 7.666667f, 4.333333f, 2.000000f, 0.034221f }, // 659 (5 5 4 2)
	{ 7.777778f, 3.777778f, 2.222222f, 0.040909f }, // 660 (5 5 5 1)
	{ 7.888889f, 3.222222f, 2.444444f, 0.051429f }, // 661 (5 5 6 0)
	{ 7.666667f, 5.666667f, 1.333333f, 0.024000f }, // 662 (5 6 0 5)
	{ 7.777778f, 5.111111f, 1.555556f, 0.026786f }, // 663 (5 6 1 4)
	{ 7.888889f, 4.555555f, 1.777778f, 0.030508f }, // 664 (5 6 2 3)
	{ 8.000000f, 4.000000f, 2.000000f, 0.035714f }, // 665 (5 6 3 2)
	{ 8.111111f, 3.444444f, 2.222222f, 0.043478f }, // 666 (5 6 4 1)
	{ 8.222222f, 2.888889f, 2.444444f, 0.056250f }, // 667 (5 6 5 0)
	{ 8.111111f, 4.777778f, 1.555556f, 0.027523f }, // 668 (5 7 0 4)
	{ 8.222222f, 4.222222f, 1.777778f, 0.031690f }, // 669 (5 7 1 3)
	{ 8.333333f, 3.666667f, 2.000000f, 0.037657f }, // 670 (5 7 2 2)
	{ 8.444445f, 3.111111f, 2.222222f, 0.046875f }, // 671 (5 7 3 1)
	{ 8.555555f, 2.555556f, 2.444444f, 0.062937f }, // 672 (5 7 4 0)
	{ 8.555555f, 3.888889f, 1.777778f, 0.033210f }, // 673 (5 8 0 3)
	{ 8.666667f, 3.333333f, 2.000000f, 0.040179f }, // 674 (5 8 1 2)
	{ 8.777778f, 2.777778f, 2.222222f, 0.051429f }, // 675 (5 8 2 1)
	{ 8.888889f, 2.222222f, 2.444444f, 0.072581f }, // 676 (5 8 3 0)
	{ 9.000000f, 3.000000f, 2.000000f, 0.043478f }, // 677 (5 9 0 2)
	{ 9.111111f, 2.444444f, 2.222222f, 0.057692f }, // 678 (5 9 1 1)
	{ 9.222222f, 1.888889f, 2.444444f, 0.087379f }, // 679 (5 9 2 0)
	{ 9.444445f, 2.111111f, 2.222222f, 0.066667f }, // 680 (5 10 0 1)
	{ 9.555555f, 1.555556f, 2.444444f, 0.112500f }, // 681 (5 10 1 0)
	{ 9.888889f, 1.222222f, 2.444444f, 0.163636f }, // 682 (5 11 0 0)
	{ 6.000000f, 10.000000f, 0.000000f, 0.016667f }, // 683 (6 0 0 10)
	{ 6.111111f, 9.444445f, 0.222222f, 0.017341f }, // 684 (6 0 1 9)
	{ 6.222222f, 8.888889f, 0.444444f, 0.018145f }, // 685 (6 0 2 8)
	{ 6.333333f, 8.333333f, 0.666667f, 0.019108f }, // 686 (6 0 3 7)
	{ 6.444445f, 7.777778f, 0.888889f, 0.020270f }, // 687 (6 0 4 6)
	{ 6.555555f, 7.222222f, 1.111111f, 0.021687f }, // 688 (6 0 5 5)
	{ 6.666667f, 6.666667f, 1.333333f, 0.023438f }, // 689 (6 0 6 4)
	{ 6.777778f, 6.111111f, 1.555556f, 0.025641f }, // 690 (6 0 7 3)
	{ 6.888889f, 5.555555f, 1.777778f, 0.028481f }, // 691 (6 0 8 2)
	{ 7.000000f, 5.000000f, 2.000000f, 0.032258f }, // 692 (6 0 9 1)
	{ 7.111111f, 4.444445f, 2.222222f, 0.037500f }, // 693 (6 0 10 0)
	{ 6.444445f, 9.111111f, 0.222222f, 0.017045f }, // 694 (6 1 0 9)
	{ 6.555555f, 8.555555f, 0.444444f, 0.017893f }, // 695 (6 1 1 8)
	{ 6.666667f, 8.000000f, 0.666667f, 0.018908f }, // 696 (6 1 2 7)
	{ 6.777778f, 7.444445f, 0.888889f, 0.020134f }, // 697 (6 1 3 6)
	{ 6.888889f, 6.888889f, 1.111111f, 0.021635f }, // 698 (6 1 4 5)
	{ 7.000000f, 6.333333f, 1.333333f, 0.023499f }, // 699 (6 1 5 4)
	{ 7.111111f, 5.777778f, 1.555556f, 0.025862f }, // 700 (6 1 6 3)
	{ 7.222222f, 5.222222f, 1.777778f, 0.028939f }, // 701 (6 1 7 2)
	{ 7.333333f, 4.666667f, 2.000000f, 0.033088f }, // 702 (6 1 8 1)
	{ 7.444445f, 4.111111f, 2.222222f, 0.038961f }, // 703 (6 1 9 0)
	{ 6.888889f, 8.222222f, 0.444444f, 0.017717f }, // 704 (6 2 0 8)
	{ 7.000000f, 7.666667f, 0.666667f, 0.018789f }, // 705 (6 2 1 7)
	{ 7.111111f, 7.111111f, 0.888889f, 0.020089f }, // 706 (6 2 2 6)
	{ 7.222222f, 6.555555f, 1.111111f, 0.021687f }, // 707 (6 2 3 5)
	{ 7.333333f, 6.000000f, 1.333333f, 0.023684f }, // 708 (6 2 4 4)
	{ 7.444445f, 5.444445f, 1.555556f, 0.026239f }, // 709 (6 2 5 3)
	{ 7.555555f, 4.888889f, 1.777778f, 0.029605f }, // 710 (6 2 6 2)
	{ 7.666667f, 4.333333f, 2.000000f, 0.034221f }, // 711 (6 2 7 1)
	{ 7.777778f, 3.777778f, 2.222222f, 0.040909f }, // 712 (6 2 8 0)
	{ 7.333333f, 7.333333f, 0.666667f, 0.018750f }, // 713 (6 3 0 7)
	{ 7.444445f, 6.777778f, 0.888889f, 0.020134f }, // 714 (6 3 1 6)
	{ 7.555555f, 6.222222f, 1.111111f, 0.021845f }, // 715 (6 3 2 5)
	{ 7.666667f, 5.666667f, 1.333333f, 0.024000f }, // 716 (6 3 3 4)
	{ 7.777778f, 5.111111f, 1.555556f, 0.026786f }, // 717 (6 3 4 3)
	{ 7.888889f, 4.555555f, 1.777778f, 0.030508f }, // 718 (6 3 5 2)
	{ 8.000000f, 4.000000f, 2.000000f, 0.035714f }, // 719 (6 3 6 1)
	{ 8.111111f, 3.444444f, 2.222222f, 0.043478f }, // 720 (6 3 7 0)
	{ 7.777778f, 6.444445f, 0.888889f, 0.020270f }, // 721 (6 4 0 6)
	{ 7.888889f, 5.888889f, 1.111111f, 0.022113f }, // 722 (6 4 1 5)
	{ 8.000000f, 5.333333f, 1.333333f, 0.024457f }, // 723 (6 4 2 4)
	{ 8.111111f, 4.777778f, 1.555556f, 0.027523f }, // 724 (6 4 3 3)
	{ 8.222222f, 4.222222f, 1.777778f, 0.031690f }, // 725 (6 4 4 2)
	{ 8.333333f, 3.666667f, 2.000000f, 0.037657f }, // 726 (6 4 5 1)
	{ 8.444445f, 3.111111f, 2.222222f, 0.046875f }, // 727 (6 4 6 0)
	{ 8.222222f, 5.555555f, 1.111111f, 0.022500f }, // 728 (6 5 0 5)
	{ 8.333333f, 5.000000f, 1.333333f, 0.025070f }, // 729 (6 5 1 4)
	{ 8.444445f, 4.444445f, 1.555556f, 0.028481f }, // 730 (6 5 2 3)
	{ 8.555555f, 3.888889f, 1.777778f, 0.033210f }, // 731 (6 5 3 2)
	{ 8.666667f, 3.333333f, 2.000000f, 0.040179f }, // 732 (6 5 4 1)
	{ 8.777778f, 2.777778f, 2.222222f, 0.051429f }, // 733 (6 5 5 0)
	{ 8.666667f, 4.666667f, 1.333333f, 0.025862f }, // 734 (6 6 0 4)
	{ 8.777778f, 4.111111f, 1.555556f, 0.029703f }, // 735 (6 6 1 3)
	{ 8.888889f, 3.555556f, 1.777778f, 0.035156f }, // 736 (6 6 2 2)
	{ 9.000000f, 3.000000f, 2.000000f, 0.043478f }, // 737 (6 6 3 1)
	{ 9.111111f, 2.444444f, 2.222222f, 0.057692f }, // 738 (6 6 4 0)
	{ 9.111111f, 3.777778f, 1.555556f, 0.031250f }, // 739 (6 7 0 3)
	{ 9.222222f, 3.222222f, 1.777778f, 0.037657f }, // 740 (6 7 1 2)
	{ 9.333333f, 2.666667f, 2.000000f, 0.047872f }, // 741 (6 7 2 1)
	{ 9.444445f, 2.111111f, 2.222222f, 0.066667f }, // 742 (6 7 3 0)
	{ 9.555555f, 2.888889f, 1.777778f, 0.040909f }, // 743 (6 8 0 2)
	{ 9.666667f, 2.333333f, 2.000000f, 0.053892f }, // 744 (6 8 1 1)
	{ 9.777778f, 1.777778f, 2.222222f, 0.080357f }, // 745 (6 8 2 0)
	{ 10.000000f, 2.000000f, 2.000000f, 0.062500f }, // 746 (6 9 0 1)
	{ 10.111111f, 1.444444f, 2.222222f, 0.103448f }, // 747 (6 9 1 0)
	{ 10.444445f, 1.111111f, 2.222222f, 0.150000f }, // 748 (6 10 0 0)
	{ 7.000000f, 9.000000f, 0.000000f, 0.015873f }, // 749 (7 0 0 9)
	{ 7.111111f, 8.444445f, 0.222222f, 0.016667f }, // 750 (7 0 1 8)
	{ 7.222222f, 7.888889f, 0.444444f, 0.017613f }, // 751 (7 0 2 7)
	{ 7.333333f, 7.333333f, 0.666667f, 0.018750f }, // 752 (7 0 3 6)
	{ 7.444445f, 6.777778f, 0.888889f, 0.020134f }, // 753 (7 0 4 5)
	{ 7.555555f, 6.222222f, 1.111111f, 0.021845f }, // 754 (7 0 5 4)
	{ 7.666667f, 5.666667f, 1.333333f, 0.024000f }, // 755 (7 0 6 3)
	{ 7.777778f, 5.111111f, 1.555556f, 0.026786f }, // 756 (7 0 7 2)
	{ 7.888889f, 4.555555f, 1.777778f, 0.030508f }, // 757 (7 0 8 1)
	{ 8.000000f, 4.000000f, 2.000000f, 0.035714f }, // 758 (7 0 9 0)
	{ 7.444445f, 8.111111f, 0.222222f, 0.016575f }, // 759 (7 1 0 8)
	{ 7.555555f, 7.555555f, 0.444444f, 0.017578f }, // 760 (7 1 1 7)
	{ 7.666667f, 7.000000f, 0.666667f, 0.018789f }, // 761 (7 1 2 6)
	{ 7.777778f, 6.444445f, 0.888889f, 0.020270f }, // 762 (7 1 3 5)
	{ 7.888889f, 5.888889f, 1.111111f, 0.022113f }, // 763 (7 1 4 4)
	{ 8.000000f, 5.333333f, 1.333333f, 0.024457f }, // 764 (7 1 5 3)
	{ 8.111111f, 4.777778f, 1.555556f, 0.027523f }, // 765 (7 1 6 2)
	{ 8.222222f, 4.222222f, 1.777778f, 0.031690f }, // 766 (7 1 7 1)
	{ 8.333333f, 3.666667f, 2.000000f, 0.037657f }, // 767 (7 1 8 0)
	{ 7.888889f, 7.222222f, 0.444444f, 0.017613f }, // 768 (7 2 0 7)
	{ 8.000000f, 6.666667f, 0.666667f, 0.018908f }, // 769 (7 2 1 6)
	{ 8.111111f, 6.111111f, 0.888889f, 0.020501f }, // 770 (7 2 2 5)
	{ 8.222222f, 5.555555f, 1.111111f, 0.022500f }, // 771 (7 2 3 4)
	{ 8.333333f, 5.000000f, 1.333333f, 0.025070f }, // 772 (7 2 4 3)
	{ 8.444445f, 4.444445f, 1.555556f, 0.028481f }, // 773 (7 2 5 2)
	{ 8.555555f, 3.888889f, 1.777778f, 0.033210f }, // 774 (7 2 6 1)
	{ 8.666667f, 3.333333f, 2.000000f, 0.040179f }, // 775 (7 2 7 0)
	{ 8.333333f, 6.333333f, 0.666667f, 0.019108f }, // 776 (7 3 0 6)
	{ 8.444445f, 5.777778f, 0.888889f, 0.020833f }, // 777 (7 3 1 5)
	{ 8.555555f, 5.222222f, 1.111111f, 0.023018f }, // 778 (7 3 2 4)
	{ 8.666667f, 4.666667f, 1.333333f, 0.025862f }, // 779 (7 3 3 3)
	{ 8.777778f, 4.111111f, 1.555556f, 0.029703f }, // 780 (7 3 4 2)
	{ 8.888889f, 3.555556f, 1.777778f, 0.035156f }, // 781 (7 3 5 1)
	{ 9.000000f, 3.000000f, 2.000000f, 0.043478f }, // 782 (7 3 6 0)
	{ 8.777778f, 5.444445f, 0.888889f, 0.021277f }, // 783 (7 4 0 5)
	{ 8.888889f, 4.888889f, 1.111111f, 0.023684f }, // 784 (7 4 1 4)
	{ 9.000000f, 4.333333f, 1.333333f, 0.026866f }, // 785 (7 4 2 3)
	{ 9.111111f, 3.777778f, 1.555556f, 0.031250f }, // 786 (7 4 3 2)
	{ 9.222222f, 3.222222f, 1.777778f, 0.037657f }, // 787 (7 4 4 1)
	{ 9.333333f, 2.666667f, 2.000000f, 0.047872f }, // 788 (7 4 5 0)
	{ 9.222222f, 4.555555f, 1.111111f, 0.024523f }, // 789 (7 5 0 4)
	{ 9.333333f, 4.000000f, 1.333333f, 0.028125f }, // 790 (7 5 1 3)
	{ 9.444445f, 3.444444f, 1.555556f, 0.033210f }, // 791 (7 5 2 2)
	{ 9.555555f, 2.888889f, 1.777778f, 0.040909f }, // 792 (7 5 3 1)
	{ 9.666667f, 2.333333f, 2.000000f, 0.053892f }, // 793 (7 5 4 0)
	{ 9.666667f, 3.666667f, 1.333333f, 0.029703f }, // 794 (7 6 0 3)
	{ 9.777778f, 3.111111f, 1.555556f, 0.035714f }, // 795 (7 6 1 2)
	{ 9.888889f, 2.555556f, 1.777778f, 0.045226f }, // 796 (7 6 2 1)
	{ 10.000000f, 2.000000f, 2.000000f, 0.062500f }, // 797 (7 6 3 0)
	{ 10.111111f, 2.777778f, 1.555556f, 0.038961f }, // 798 (7 7 0 2)
	{ 10.222222f, 2.222222f, 1.777778f, 0.051136f }, // 799 (7 7 1 1)
	{ 10.333333f, 1.666667f, 2.000000f, 0.075630f }, // 800 (7 7 2 0)
	{ 10.555555f, 1.888889f, 1.777778f, 0.059603f }, // 801 (7 8 0 1)
	{ 10.666667f, 1.333333f, 2.000000f, 0.097826f }, // 802 (7 8 1 0)
	{ 11.000000f, 1.000000f, 2.000000f, 0.142857f }, // 803 (7 9 0 0)
	{ 8.000000f, 8.000000f, 0.000000f, 0.015625f }, // 804 (8 0 0 8)
	{ 8.111111f, 7.444445f, 0.222222f, 0.016575f }, // 805 (8 0 1 7)
	{ 8.222222f, 6.888889f, 0.444444f, 0.017717f }, // 806 (8 0 2 6)
	{ 8.333333f, 6.333333f, 0.666667f, 0.019108f }, // 807 (8 0 3 5)
	{ 8.444445f, 5.777778f, 0.888889f, 0.020833f }, // 808 (8 0 4 4)
	{ 8.555555f, 5.222222f, 1.111111f, 0.023018f }, // 809 (8 0 5 3)
	{ 8.666667f, 4.666667f, 1.333333f, 0.025862f }, // 810 (8 0 6 2)
	{ 8.777778f, 4.111111f, 1.555556f, 0.029703f }, // 811 (8 0 7 1)
	{ 8.888889f, 3.555556f, 1.777778f, 0.035156f }, // 812 (8 0 8 0)
	{ 8.444445f, 7.111111f, 0.222222f, 0.016667f }, // 813 (8 1 0 7)
	{ 8.555555f, 6.555555f, 0.444444f, 0.017893f }, // 814 (8 1 1 6)
	{ 8.666667f, 6.000000f, 0.666667f, 0.019397f }, // 815 (8 1 2 5)
	{ 8.777778f, 5.444445f, 0.888889f, 0.021277f }, // 816 (8 1 3 4)
	{ 8.888889f, 4.888889f, 1.111111f, 0.023684f }, // 817 (8 1 4 3)
	{ 9.000000f, 4.333333f, 1.333333f, 0.026866f }, // 818 (8 1 5 2)
	{ 9.111111f, 3.777778f, 1.555556f, 0.031250f }, // 819 (8 1 6 1)
	{ 9.222222f, 3.222222f, 1.777778f, 0.037657f }, // 820 (8 1 7 0)
	{ 8.888889f, 6.222222f, 0.444444f, 0.018145f }, // 821 (8 2 0 6)
	{ 9.000000f, 5.666667f, 0.666667f, 0.019780f }, // 822 (8 2 1 5)
	{ 9.111111f, 5.111111f, 0.888889f, 0.021845f }, // 823 (8 2 2 4)
	{ 9.222222f, 4.555555f, 1.111111f, 0.024523f }, // 824 (8 2 3 3)
	{ 9.333333f, 4.000000f, 1.333333f, 0.028125f }, // 825 (8 2 4 2)
	{ 9.444445f, 3.444444f, 1.555556f, 0.033210f }, // 826 (8 2 5 1)
	{ 9.555555f, 2.888889f, 1.777778f, 0.040909f }, // 827 (8 2 6 0)
	{ 9.333333f, 5.333333f, 0.666667f, 0.020270f }, // 828 (8 3 0 5)
	{ 9.444445f, 4.777778f, 0.888889f, 0.022556f }, // 829 (8 3 1 4)
	{ 9.555555f, 4.222222f, 1.111111f, 0.025568f }, // 830 (8 3 2 3)
	{ 9.666667f, 3.666667f, 1.333333f, 0.029703f }, // 831 (8 3 3 2)
	{ 9.777778f, 3.111111f, 1.555556f, 0.035714f }, // 832 (8 3 4 1)
	{ 9.888889f, 2.555556f, 1.777778f, 0.045226f }, // 833 (8 3 5 0)
	{ 9.777778f, 4.444445f, 0.888889f, 0.023438f }, // 834 (8 4 0 4)
	{ 9.888889f, 3.888889f, 1.111111f, 0.026866f }, // 835 (8 4 1 3)
	{ 10.000000f, 3.333333f, 1.333333f, 0.031690f }, // 836 (8 4 2 2)
	{ 10.111111f, 2.777778f, 1.555556f, 0.038961f }, // 837 (8 4 3 1)
	{ 10.222222f, 2.222222f, 1.777778f, 0.051136f }, // 838 (8 4 4 0)
	{ 10.222222f, 3.555556f, 1.111111f, 0.028481f }, // 839 (8 5 0 3)
	{ 10.333333f, 3.000000f, 1.333333f, 0.034221f }, // 840 (8 5 1 2)
	{ 10.444445f, 2.444444f, 1.555556f, 0.043269f }, // 841 (8 5 2 1)
	{ 10.555555f, 1.888889f, 1.777778f, 0.059603f }, // 842 (8 5 3 0)
	{ 10.666667f, 2.666667f, 1.333333f, 0.037500f }, // 843 (8 6 0 2)
	{ 10.777778f, 2.111111f, 1.555556f, 0.049180f }, // 844 (8 6 1 1)
	{ 10.888889f, 1.555556f, 1.777778f, 0.072581f }, // 845 (8 6 2 0)
	{ 11.111111f, 1.777778f, 1.555556f, 0.057692f }, // 846 (8 7 0 1)
	{ 11.222222f, 1.222222f, 1.777778f, 0.094737f }, // 847 (8 7 1 0)
	{ 11.555555f, 0.888889f, 1.777778f, 0.140625f }, // 848 (8 8 0 0)
	{ 9.000000f, 7.000000f, 0.000000f, 0.015873f }, // 849 (9 0 0 7)
	{ 9.111111f, 6.444445f, 0.222222f, 0.017045f }, // 850 (9 0 1 6)
	{ 9.222222f, 5.888889f, 0.444444f, 0.018480f }, // 851 (9 0 2 5)
	{ 9.333333f, 5.333333f, 0.666667f, 0.020270f }, // 852 (9 0 3 4)
	{ 9.444445f, 4.777778f, 0.888889f, 0.022556f }, // 853 (9 0 4 3)
	{ 9.555555f, 4.222222f, 1.111111f, 0.025568f }, // 854 (9 0 5 2)
	{ 9.666667f, 3.666667f, 1.333333f, 0.029703f }, // 855 (9 0 6 1)
	{ 9.777778f, 3.111111f, 1.555556f, 0.035714f }, // 856 (9 0 7 0)
	{ 9.444445f, 6.111111f, 0.222222f, 0.017341f }, // 857 (9 1 0 6)
	{ 9.555555f, 5.555555f, 0.444444f, 0.018908f }, // 858 (9 1 1 5)
	{ 9.666667f, 5.000000f, 0.666667f, 0.020882f }, // 859 (9 1 2 4)
	{ 9.777778f, 4.444445f, 0.888889f, 0.023438f }, // 860 (9 1 3 3)
	{ 9.888889f, 3.888889f, 1.111111f, 0.026866f }, // 861 (9 1 4 2)
	{ 10.000000f, 3.333333f, 1.333333f, 0.031690f }, // 862 (9 1 5 1)
	{ 10.111111f, 2.777778f, 1.555556f, 0.038961f }, // 863 (9 1 6 0)
	{ 9.888889f, 5.222222f, 0.444444f, 0.019438f }, // 864 (9 2 0 5)
	{ 10.000000f, 4.666667f, 0.666667f, 0.021635f }, // 865 (9 2 1 4)
	{ 10.111111f, 4.111111f, 0.888889f, 0.024523f }, // 866 (9 2 2 3)
	{ 10.222222f, 3.555556f, 1.111111f, 0.028481f }, // 867 (9 2 3 2)
	{ 10.333333f, 3.000000f, 1.333333f, 0.034221f }, // 868 (9 2 4 1)
	{ 10.444445f, 2.444444f, 1.555556f, 0.043269f }, // 869 (9 2 5 0)
	{ 10.333333f, 4.333333f, 0.666667f, 0.022556f }, // 870 (9 3 0 4)
	{ 10.444445f, 3.777778f, 0.888889f, 0.025862f }, // 871 (9 3 1 3)
	{ 10.555555f, 3.222222f, 1.111111f, 0.030508f }, // 872 (9 3 2 2)
	{ 10.666667f, 2.666667f, 1.333333f, 0.037500f }, // 873 (9 3 3 1)
	{ 10.777778f, 2.111111f, 1.555556f, 0.049180f }, // 874 (9 3 4 0)
	{ 10.777778f, 3.444444f, 0.888889f, 0.027523f }, // 875 (9 4 0 3)
	{ 10.888889f, 2.888889f, 1.111111f, 0.033088f }, // 876 (9 4 1 2)
	{ 11.000000f, 2.333333f, 1.333333f, 0.041860f }, // 877 (9 4 2 1)
	{ 11.111111f, 1.777778f, 1.555556f, 0.057692f }, // 878 (9 4 3 0)
	{ 11.222222f, 2.555556f, 1.111111f, 0.036437f }, // 879 (9 5 0 2)
	{ 11.333333f, 2.000000f, 1.333333f, 0.047872f }, // 880 (9 5 1 1)
	{ 11.444445f, 1.444444f, 1.555556f, 0.070866f }, // 881 (9 5 2 0)
	{ 11.666667f, 1.666667f, 1.333333f, 0.056604f }, // 882 (9 6 0 1)
	{ 11.777778f, 1.111111f, 1.555556f, 0.093750f }, // 883 (9 6 1 0)
	{ 12.111111f, 0.777778f, 1.555556f, 0.142857f }, // 884 (9 7 0 0)
	{ 10.000000f, 6.000000f, 0.000000f, 0.016667f }, // 885 (10 0 0 6)
	{ 10.111111f, 5.444445f, 0.222222f, 0.018182f }, // 886 (10 0 1 5)
	{ 10.222222f, 4.888889f, 0.444444f, 0.020089f }, // 887 (10 0 2 4)
	{ 10.333333f, 4.333333f, 0.666667f, 0.022556f }, // 888 (10 0 3 3)
	{ 10.444445f, 3.777778f, 0.888889f, 0.025862f }, // 889 (10 0 4 2)
	{ 10.555555f, 3.222222f, 1.111111f, 0.030508f }, // 890 (10 0 5 1)
	{ 10.666667f, 2.666667f, 1.333333f, 0.037500f }, // 891 (10 0 6 0)
	{ 10.444445f, 5.111111f, 0.222222f, 0.018750f }, // 892 (10 1 0 5)
	{ 10.555555f, 4.555555f, 0.444444f, 0.020882f }, // 893 (10 1 1 4)
	{ 10.666667f, 4.000000f, 0.666667f, 0.023684f }, // 894 (10 1 2 3)
	{ 10.777778f, 3.444444f, 0.888889f, 0.027523f }, // 895 (10 1 3 2)
	{ 10.888889f, 2.888889f, 1.111111f, 0.033088f }, // 896 (10 1 4 1)
	{ 11.000000f, 2.333333f, 1.333333f, 0.041860f }, // 897 (10 1 5 0)
	{ 10.888889f, 4.222222f, 0.444444f, 0.021845f }, // 898 (10 2 0 4)
	{ 11.000000f, 3.666667f, 0.666667f, 0.025070f }, // 899 (10 2 1 3)
	{ 11.111111f, 3.111111f, 0.888889f, 0.029605f }, // 900 (10 2 2 2)
	{ 11.222222f, 2.555556f, 1.111111f, 0.036437f }, // 901 (10 2 3 1)
	{ 11.333333f, 2.000000f, 1.333333f, 0.047872f }, // 902 (10 2 4 0)
	{ 11.333333f, 3.333333f, 0.666667f, 0.026786f }, // 903 (10 3 0 3)
	{ 11.444445f, 2.777778f, 0.888889f, 0.032258f }, // 904 (10 3 1 2)
	{ 11.555555f, 2.222222f, 1.111111f, 0.040909f }, // 905 (10 3 2 1)
	{ 11.666667f, 1.666667f, 1.333333f, 0.056604f }, // 906 (10 3 3 0)
	{ 11.777778f, 2.444444f, 0.888889f, 0.035714f }, // 907 (10 4 0 2)
	{ 11.888889f, 1.888889f, 1.111111f, 0.047120f }, // 908 (10 4 1 1)
	{ 12.000000f, 1.333333f, 1.333333f, 0.070313f }, // 909 (10 4 2 0)
	{ 12.222222f, 1.555556f, 1.111111f, 0.056250f }, // 910 (10 5 0 1)
	{ 12.333333f, 1.000000f, 1.333333f, 0.094737f }, // 911 (10 5 1 0)
	{ 12.666667f, 0.666667f, 1.333333f, 0.150000f }, // 912 (10 6 0 0)
	{ 11.000000f, 5.000000f, 0.000000f, 0.018182f }, // 913 (11 0 0 5)
	{ 11.111111f, 4.444445f, 0.222222f, 0.020270f }, // 914 (11 0 1 4)
	{ 11.222222f, 3.888889f, 0.444444f, 0.023018f }, // 915 (11 0 2 3)
	{ 11.333333f, 3.333333f, 0.666667f, 0.026786f }, // 916 (11 0 3 2)
	{ 11.444445f, 2.777778f, 0.888889f, 0.032258f }, // 917 (11 0 4 1)
	{ 11.555555f, 2.222222f, 1.111111f, 0.040909f }, // 918 (11 0 5 0)
	{ 11.444445f, 4.111111f, 0.222222f, 0.021277f }, // 919 (11 1 0 4)
	{ 11.555555f, 3.555556f, 0.444444f, 0.024457f }, // 920 (11 1 1 3)
	{ 11.666667f, 3.000000f, 0.666667f, 0.028939f }, // 921 (11 1 2 2)
	{ 11.777778f, 2.444444f, 0.888889f, 0.035714f }, // 922 (11 1 3 1)
	{ 11.888889f, 1.888889f, 1.111111f, 0.047120f }, // 923 (11 1 4 0)
	{ 11.888889f, 3.222222f, 0.444444f, 0.026239f }, // 924 (11 2 0 3)
	{ 12.000000f, 2.666667f, 0.666667f, 0.031690f }, // 925 (11 2 1 2)
	{ 12.111111f, 2.111111f, 0.888889f, 0.040359f }, // 926 (11 2 2 1)
	{ 12.222222f, 1.555556f, 1.111111f, 0.056250f }, // 927 (11 2 3 0)
	{ 12.333333f, 2.333333f, 0.666667f, 0.035294f }, // 928 (11 3 0 2)
	{ 12.444445f, 1.777778f, 0.888889f, 0.046875f }, // 929 (11 3 1 1)
	{ 12.555555f, 1.222222f, 1.111111f, 0.070866f }, // 930 (11 3 2 0)
	{ 12.777778f, 1.444444f, 0.888889f, 0.056604f }, // 931 (11 4 0 1)
	{ 12.888889f, 0.888889f, 1.111111f, 0.097826f }, // 932 (11 4 1 0)
	{ 13.222222f, 0.555556f, 1.111111f, 0.163636f }, // 933 (11 5 0 0)
	{ 12.000000f, 4.000000f, 0.000000f, 0.020833f }, // 934 (12 0 0 4)
	{ 12.111111f, 3.444444f, 0.222222f, 0.024000f }, // 935 (12 0 1 3)
	{ 12.222222f, 2.888889f, 0.444444f, 0.028481f }, // 936 (12 0 2 2)
	{ 12.333333f, 2.333333f, 0.666667f, 0.035294f }, // 937 (12 0 3 1)
	{ 12.444445f, 1.777778f, 0.888889f, 0.046875f }, // 938 (12 0 4 0)
	{ 12.444445f, 3.111111f, 0.222222f, 0.025862f }, // 939 (12 1 0 3)
	{ 12.555555f, 2.555556f, 0.444444f, 0.031359f }, // 940 (12 1 1 2)
	{ 12.666667f, 2.000000f, 0.666667f, 0.040179f }, // 941 (12 1 2 1)
	{ 12.777778f, 1.444444f, 0.888889f, 0.056604f }, // 942 (12 1 3 0)
	{ 12.888889f, 2.222222f, 0.444444f, 0.035156f }, // 943 (12 2 0 2)
	{ 13.000000f, 1.666667f, 0.666667f, 0.047120f }, // 944 (12 2 1 1)
	{ 13.111111f, 1.111111f, 0.888889f, 0.072581f }, // 945 (12 2 2 0)
	{ 13.333333f, 1.333333f, 0.666667f, 0.057692f }, // 946 (12 3 0 1)
	{ 13.444445f, 0.777778f, 0.888889f, 0.103448f }, // 947 (12 3 1 0)
	{ 13.777778f, 0.444444f, 0.888889f, 0.187500f }, // 948 (12 4 0 0)
	{ 13.000000f, 3.000000f, 0.000000f, 0.025641f }, // 949 (13 0 0 3)
	{ 13.111111f, 2.444444f, 0.222222f, 0.031250f }, // 950 (13 0 1 2)
	{ 13.222222f, 1.888889f, 0.444444f, 0.040359f }, // 951 (13 0 2 1)
	{ 13.333333f, 1.333333f, 0.666667f, 0.057692f }, // 952 (13 0 3 0)
	{ 13.444445f, 2.111111f, 0.222222f, 0.035294f }, // 953 (13 1 0 2)
	{ 13.555555f, 1.555556f, 0.444444f, 0.047872f }, // 954 (13 1 1 1)
	{ 13.666667f, 1.000000f, 0.666667f, 0.075630f }, // 955 (13 1 2 0)
	{ 13.888889f, 1.222222f, 0.444444f, 0.059603f }, // 956 (13 2 0 1)
	{ 14.000000f, 0.666667f, 0.666667f, 0.112500f }, // 957 (13 2 1 0)
	{ 14.333333f, 0.333333f, 0.666667f, 0.230769f }, // 958 (13 3 0 0)
	{ 14.000000f, 2.000000f, 0.000000f, 0.035714f }, // 959 (14 0 0 2)
	{ 14.111111f, 1.444444f, 0.222222f, 0.049180f }, // 960 (14 0 1 1)
	{ 14.222222f, 0.888889f, 0.444444f, 0.080357f }, // 961 (14 0 2 0)
	{ 14.444445f, 1.111111f, 0.222222f, 0.062500f }, // 962 (14 1 0 1)
	{ 14.555555f, 0.555556f, 0.444444f, 0.126761f }, // 963 (14 1 1 0)
	{ 14.888889f, 0.222222f, 0.444444f, 0.321429f }, // 964 (14 2 0 0)
	{ 15.000000f, 1.000000f, 0.000000f, 0.066667f }, // 965 (15 0 0 1)
	{ 15.111111f, 0.444444f, 0.222222f, 0.150000f }, // 966 (15 0 1 0)
	{ 15.444445f, 0.111111f, 0.222222f, 0.600000f }, // 967 (15 1 0 0)
	{ 16.000000f, 0.000000f, 0.000000f, FLT_MAX }, // 968 (16 0 0 0)
}; // 969 four cluster elements

