.TH 9wm 1

.SH NAME
9wm \- rio-like Window Manager for X
.SH SYNOPSIS
.B 9wm
[
.B \-border
] [
.B \-cursor
.I cursor
] [
.B \-version
] [
.B \-font
.I fname
] [
.B \-term
.I termprog
] [
.B \-active
.I color
] [
.B \-inactive
.I color
] [
.BR exit | restart
]

.SH DESCRIPTION
.I 9wm
is a window manager for X which attempts to emulate the window management
policies of Plan 9's 
.I rio
window manager.
.PP
.I 9wm
is click-to-type: it has a notion of the current window,
which is usually on top, and always has its border darkened.
Characters typed at the keyboard go to the current window,
and mouse clicks outside the current window are swallowed up
by
.IR 9wm .
To make another window the current one, click on it with button 1.
Unlike other X window managers, 9wm implements `mouse focus': mouse events
are sent only to the current window.

.SH OPTIONS
.IP \-border
Shrinks the size of window borders to be more like Plan9.
.IP "\-cursor cursor"
Sets the cursor to one of two custom Plan9-style cursors:
.IR v1
or
.IR blit.
Use this option for maximum authenticity.
.IP "\-font fname"
Sets the font in
.IR 9wm 's
menu to
.IR fname ,
overriding the default.
.IP "\-term termprog"
Specifies an alternative program to run when the
.I New
menu item is selected.
.IP "\-active color"
Sets the color of the active window border, which defaults to black.
.IP "\-inactive color"
Sets the color of the inactive window border, which defaults to white.
.IP \-version
Prints the current version on standard error, then exits.

.SH MENU
.PP
A menu of window operations is available by pressing button 3
outside the current window.
.IP New
attempts to spawn a
.I 9term
process (or
.I xterm
if
.I 9term
is not available).
.PP
All of the next operations change the cursor into a target, prompting the user
to click button 3 on one of the windows to select it for the operation.
At this stage, clicking button 1 or 2 will abort the operation.
.IP Resize
The user is prompted to sweep out the new outline with button 3.
.IP Move
The user should keep the button held down after the initial click that selected
the window, and drag the window to the right place before releasing.
In either case, button 1 or 2 will abort the operation.
.IP Delete
The window will be deleted when the button is released.
This typically kills the client that owns the window.
.IP Hide
Makes the window invisible.  While hidden, the window's
name appears on the bottom of the button 3 menu.  Selecting that item
brings the window back (unhides it).
This operation replaces the iconification feature provided by other
window managers.
.PP
To make 
.I 9wm
exit, you have to run
.B "9wm exit"
on the command line.  There is no ``exit'' menu item.

.SH BUGS
Is not completely compatible with rio.

.PP
There is a currently a compiled-in limit of 32 hidden windows.
.SH "SEE ALSO"
.IR 9term (1),
.IR xterm (1).
