{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFlipVertically: Boolean;
    procedure SetFlipVertically(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdUrl: TMFString;
    { Internal wrapper for property @code(Url). This wrapper API may change, we advise to access simpler @code(Url) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUrl: TMFString read FFdUrl;
    {  }
    procedure SetUrl(const Value: array of string); overload;
    {  }
    procedure SetUrl(const Value: TCastleStringList); overload;

    strict private FFdFlipVertically: TSFBool;
    { Internal wrapper for property @code(FlipVertically). This wrapper API may change, we advise to access simpler @code(FlipVertically) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFlipVertically: TSFBool read FFdFlipVertically;
    {  }
    property FlipVertically: Boolean read GetFlipVertically write SetFlipVertically;

{$endif read_interface}

{$ifdef read_implementation}

{ TImageTextureNode ----------------------------------------------- }

procedure TImageTextureNode.SetUrl(const Value: array of string);
begin
  FdUrl.Send(Value);
end;

procedure TImageTextureNode.SetUrl(const Value: TCastleStringList);
begin
  FdUrl.Send(Value);
end;

function TImageTextureNode.GetFlipVertically: Boolean;
begin
  Result := FdFlipVertically.Value;
end;

procedure TImageTextureNode.SetFlipVertically(const Value: Boolean);
begin
  FdFlipVertically.Send(Value);
end;

class function TImageTextureNode.ClassX3DType: String;
begin
  Result := 'ImageTexture';
end;

procedure TImageTextureNode.CreateNode;
begin
  inherited;

  FFdUrl := TMFString.Create(Self, True, 'url', []);
   FdUrl.ChangeAlways := chTextureImage;
  AddField(FFdUrl);

  FFdFlipVertically := TSFBool.Create(Self, False, 'flipVertically', false);
   FdFlipVertically.ChangeAlways := chTextureImage;
  AddField(FFdFlipVertically);
end;

{$endif read_implementation}
