{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFieldOfView: Single;
    procedure SetFieldOfView(const Value: Single);
    function GetUpVector: TVector3;
    procedure SetUpVector(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdFieldOfView: TSFFloat;
    { Internal wrapper for property @code(FieldOfView). This wrapper API may change, we advise to access simpler @code(FieldOfView) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFieldOfView: TSFFloat read FFdFieldOfView;
    {  }
    property FieldOfView: Single read GetFieldOfView write SetFieldOfView;

    strict private FFdUpVector: TSFVec3f;
    { Internal wrapper for property @code(UpVector). This wrapper API may change, we advise to access simpler @code(UpVector) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUpVector: TSFVec3f read FFdUpVector;
    {  }
    property UpVector: TVector3 read GetUpVector write SetUpVector;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureProjectorNode ----------------------------------------------- }

function TTextureProjectorNode.GetFieldOfView: Single;
begin
  Result := FdFieldOfView.Value;
end;

procedure TTextureProjectorNode.SetFieldOfView(const Value: Single);
begin
  FdFieldOfView.Send(Value);
end;

function TTextureProjectorNode.GetUpVector: TVector3;
begin
  Result := FdUpVector.Value;
end;

procedure TTextureProjectorNode.SetUpVector(const Value: TVector3);
begin
  FdUpVector.Send(Value);
end;

class function TTextureProjectorNode.ClassX3DType: String;
begin
  Result := 'TextureProjector';
end;

procedure TTextureProjectorNode.CreateNode;
begin
  inherited;

  FFdFieldOfView := TSFFloat.Create(Self, True, 'fieldOfView', Pi/4);
   FdFieldOfView.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFieldOfView);

  FFdUpVector := TSFVec3f.Create(Self, True, 'upVector', Vector3(0, 0, 1));
   FdUpVector.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUpVector);
end;

{$endif read_implementation}
