(*^

::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "NeXT Mathematica Notebook Front End Version 2.2";

	NeXTStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e8,  24, "Times"; ;
	fontset = subtitle, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e6,  18, "Times"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, L1, e6,  14, "Times"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L1, a20,  18, "Times"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L1, a15,  14, "Times"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L1, a12,  12, "Times"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  10, "Times"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L1,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L1,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L1,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L1,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L1,  12, "Courier"; ;
	fontset = name, inactive, noPageBreakInGroup, nohscroll, preserveAspect, M7, italic, B65535, L1,  10, "Times"; ;
	fontset = header, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, L1,  12, "Times"; ;
	fontset = leftheader,  12;
	fontset = footer, inactive, nohscroll, noKeepOnOnePage, preserveAspect, center, M7, italic, L1,  12, "Times"; ;
	fontset = leftfooter,  12;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Courier"; ;
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; preserveAspect; startGroup]
General Surface Plotting
:[font = text; inactive; preserveAspect]
This notebook demonstrates functions for plotting surfaces from data. 
The topic is described in more detail in the book:

	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.
:[font = section; inactive; preserveAspect; startGroup]
Initialize
:[font = subsection; inactive; preserveAspect; startGroup]
Set $Path
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
For Unix
:[font = input; preserveAspect; endGroup]
AppendTo[ $Path, "/usr/local/TWJ_Packages"];
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
For MS Windows
:[font = input; preserveAspect]
AppendTo[ $Path, "c:\\twjpacks"];
:[font = input; preserveAspect; endGroup]
Get[ "dosgraph.m"]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
For Macintosh
:[font = input; preserveAspect; endGroup; endGroup]
AppendTo[ $Path, "Macintosh HD:TWJ_Packages"];
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Load Packages
:[font = input; preserveAspect; endGroup]
Needs[ "ExtendGraphics`SurfaceGraphics3D`"]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Turn off spelling checker
:[font = input; preserveAspect; endGroup; endGroup]
Off[ General::spell];
Off[ General::spell1];

:[font = section; inactive; Cclosed; preserveAspect; startGroup]
General Surface Plotting
:[font = text; inactive; preserveAspect]
Some data is generated.
:[font = input; preserveAspect]
data =
  Table[
    Table[{r Sin[t], r Cos[t], 
	                 Cos[2t] BesselJ[1, 7 r]},
          {t, 0, 2Pi-2Pi/( 10 r),2Pi/ (10 r)}],
      {r,5}];
      
data = Flatten[data, 1];
:[font = text; inactive; preserveAspect]
The data is plotted.
:[font = input; preserveAspect]
surf = ListSurfacePlot3D[data];
:[font = text; inactive; preserveAspect]
The surface is colored with a ColorFunction.
:[font = input; preserveAspect; endGroup; endGroup]
Show[surf, 
    MeshStyle -> GrayLevel[0.25],
    ColorFunction -> Hue];
^*)
