#if   !defined(__GUARDSEMAPHORE_HPP)
#define  __GUARDSEMAPHORE_HPP

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__SEMAPHORE_HPP)
#include <Semaphore.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( GuardSemaphore );

   /**
   GuardSemaphore is a special case semaphore for use by the
   CoreLinuxGuardPool. It has the basic behavior of a MutexSemaphore
   without the recursion and balking capability. Its sole use is
   for Synchronized object monitor control.
   @see corelinux::CoreLinuxGuardPool
   @see corelinux::Semaphore
   */

   class GuardSemaphore : public Semaphore
   {
   public:

      //
      // Constructors and destructors
      //

                           /**
                           Default constructor requires the identifier
                           of the semaphore in the semaphore group
                           @param SemaphoreGroup The 
                           owning SemaphoreGroup
                           @param SemaphoreIdentifier The identifier
                           from the Semaphore Group
                           */

                           GuardSemaphore
                              ( 
                                 SemaphoreGroupPtr,
                                 SemaphoreIdentifierRef
                              ) throw(Assertion);

                           /// Virtual Destructor

      virtual              ~GuardSemaphore( void );

      //
      // Mutators
      //
      
               /// Request the lock, wait for availability
      
      virtual  SemaphoreOperationStatus lockWithWait(void) 
                              throw(SemaphoreException);

               /// Request the lock without waiting
      
      virtual  SemaphoreOperationStatus lockWithNoWait(void) 
                              throw(SemaphoreException);

               /// Ask if AbstractSemaphore instance is locked
      
      virtual  bool isLocked(void) ;

               /// Request the AbstractSemaphore but timeout if not available
      
      //      virtual  SemaphoreOperationStatus   lockWithTimeOut( Timer )
      //                   throw(SemaphoreException) = 0;
      
               /// Release the lock
      
      virtual  SemaphoreOperationStatus release(void) 
                              throw(SemaphoreException);

   protected:

         //
         // Constructors
         //

                              /// Default constructor throws assertion

                              GuardSemaphore( void ) 
                                 throw(Assertion);

                              /// Copy constructor throws assertion

                              GuardSemaphore( GuardSemaphoreCref ) 
                                 throw(Assertion);

         //
         // Operator overloads
         //
                  /// Assignment operator throws assertion

                  GuardSemaphoreRef operator=( GuardSemaphoreCref ) 
                                 throw(Assertion);

   };
}

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/06/02 11:51:52 $
   $Locker:  $
*/


