/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;


public class ObjectPoolTest
	extends junit.framework.TestCase
{
	public ObjectPoolTest(String name) 
	{
		super(name);
	}

	public void testBasic()
	{
		ObjectPool pool = new ObjectPool(StringBuffer.class, 16);
		for (int i = 0; i < 1024; i++)
			pool.checkOut();
		System.out.println("pool " + pool);
		for (int i = 0; i < 1024; i++)
			pool.checkIn();
		System.out.println("pool " + pool);
		StringBuffer sb;
		StringBuffer sb2;
		sb = (StringBuffer)pool.checkOut();
		sb.append("haha");
		pool.checkIn();
		sb2 = (StringBuffer)pool.checkOut();
		assertEquals("same haha", sb, sb2);
	}

	public abstract class Bogus {
		public Bogus() {
		}
		abstract void something();
	}

	public void testExceptions() 
	{
		try {
			new ObjectPool(StringBuffer.class, 0);
			fail("Must not create zero sized stack");
		} catch (IllegalArgumentException e) { }
		try {
			new ObjectPool(Bogus.class, 0);
			fail("Must not create bogus class");
		} catch (IllegalArgumentException e) { }
		try {
			new ObjectPool(null, 1);
			fail("Must not create null prototype");
		} catch (IllegalArgumentException e) { }
		try {
			new ObjectPool(Integer.class, 1);
			fail("Must not create bogus prototype");
		} catch (IllegalArgumentException e) { }
		try {
			ObjectPool pool = new ObjectPool(StringBuffer.class, 1);
			pool.checkIn();
			fail("Must not checkIn() excessively");
		} catch (IllegalStateException e) {
		}
		try {
			ObjectPool pool = new ObjectPool(StringBuffer.class, 1);
			pool.checkOut();
			pool.checkIn();
			pool.checkIn();
			fail("Must not checkIn() excessively");
		} catch (IllegalStateException e) {
		}
	}

	public void testIt() 
	{
		ObjectPool pool = new ObjectPool(Object.class, 5);
		Object o1 = pool.checkOut();
		assertSame(o1, pool.checkIn());
		Object o2 = pool.checkOut();
		assertSame(o2, pool.checkIn());
	}
}
